/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.precondition.Alert;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.precondition.PreconditionService;
import com.atlassian.servicedesk.internal.rest.responses.PreconditionCheckResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/{projectKey}/precondition")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PreconditionCheckResource {
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final InternalServiceDeskService internalServiceDeskService;
    private final PortalService portalService;
    private final UserFactory userFactory;
    private final PreconditionService preconditionService;
    private final RestResponseHelper restResponseHelper;

    public PreconditionCheckResource(InternalServiceDeskProjectManager internalServiceDeskProjectManager, InternalServiceDeskService internalServiceDeskService, PortalService portalService, UserFactory userFactory, PreconditionService preconditionService, RestResponseHelper restResponseHelper) {
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.internalServiceDeskService = internalServiceDeskService;
        this.portalService = portalService;
        this.userFactory = userFactory;
        this.preconditionService = preconditionService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response checkPreconditionForProject(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = this.checkPreconditions(projectKey).map(PreconditionCheckResponse::new);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, List<Alert>> checkPreconditions(String projectKey) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).then((user, project, sd) -> StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user.forJIRA(), project))).yield((user, project, sd, portal) -> this.preconditionService.checkPreconditions((ServiceDesk)sd, (Project)project, (Portal)portal));
    }
}

