/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManager;
import com.atlassian.servicedesk.internal.api.search.user.UserSearchManagerHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.CustomerUserPickerPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.search.user.CustomerSearchService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.PickerServiceDeskUserValueFactory;
import com.atlassian.servicedesk.internal.rest.responses.PickerServiceDeskUserValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="user-search")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PortalUserPickerResource {
    private static final Integer LIMIT = 10;
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final ServiceDeskService serviceDeskService;
    private final UserSearchManager userSearchManager;
    private final UserSearchManagerHelper userSearchManagerHelper;
    private final CustomerUserPickerPermissionService customerUserPickerPermissionService;
    private final PickerServiceDeskUserValueFactory pickerServiceDeskUserValueFactory;
    private final RestResponseHelper restResponseHelper;
    private final CustomerSearchService customerSearchService;
    private final FeatureManager featureManager;

    public PortalUserPickerResource(UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, ServiceDeskService serviceDeskService, UserSearchManager userSearchManager, UserSearchManagerHelper userSearchManagerHelper, CustomerUserPickerPermissionService customerUserPickerPermissionService, PickerServiceDeskUserValueFactory pickerServiceDeskUserValueFactory, RestResponseHelper restResponseHelper, CustomerSearchService customerSearchService, FeatureManager featureManager) {
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskService = serviceDeskService;
        this.userSearchManager = userSearchManager;
        this.userSearchManagerHelper = userSearchManagerHelper;
        this.customerUserPickerPermissionService = customerUserPickerPermissionService;
        this.pickerServiceDeskUserValueFactory = pickerServiceDeskUserValueFactory;
        this.restResponseHelper = restResponseHelper;
        this.customerSearchService = customerSearchService;
        this.featureManager = featureManager;
    }

    @GET
    public Response searchCustomers(@QueryParam(value="query") String query, @QueryParam(value="projectId") String projectId, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldConfigId") String fieldConfigId) {
        io.atlassian.fugue.Option pickerUsers = Steps.begin((io.atlassian.fugue.Option)StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption())).then(checkedUser -> this.getSearchResults((CheckedUser)checkedUser, query, projectId, fieldName, fieldConfigId)).then((checkedUser, userList) -> this.transformResults((List<CheckedUser>)userList)).yield((checkedUser, userList, pickerUserList) -> pickerUserList);
        return this.restResponseHelper.ok(pickerUsers.getOrElse(Collections.emptyList()));
    }

    private io.atlassian.fugue.Option<List<CheckedUser>> getSearchResults(CheckedUser user, String query, String projectId, String fieldName, String fieldConfigId) {
        return Steps.begin(this.getProjectById(projectId, user)).then(project -> StepsConverters.newerOption((Option)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project).toOption())).then((project, serviceDesk) -> this.hasPermissionToBrowseUsers(user, (Project)project, (ServiceDesk)serviceDesk)).then((project, serviceDesk, unit) -> {
            if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
                return this.customerSearchService.searchForCustomers(user, (Project)project, (ServiceDesk)serviceDesk, query, LIMIT, fieldName, (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.option((Object)fieldConfigId)).toOption();
            }
            return this.userSearchManagerHelper.buildPortalCustomerUserSearchParamsWithoutOrganizations(fieldName, io.atlassian.fugue.Option.option((Object)fieldConfigId), project, serviceDesk, io.atlassian.fugue.Option.some((Object)LIMIT)).map(userSearchParams -> this.userSearchManager.search(query, userSearchParams).flatMap(this::wrapResult).collect(Collectors.toList()));
        }).yield((project, serviceDesk, unit, users) -> ImmutableList.copyOf((Collection)users));
    }

    private Stream<CheckedUser> wrapResult(ApplicationUser result) {
        return Lists.newArrayList((Iterator)this.userFactory.wrap(result).toOption().iterator()).stream();
    }

    private io.atlassian.fugue.Option<List<PickerServiceDeskUserValue>> transformResults(List<CheckedUser> searchResults) {
        return io.atlassian.fugue.Option.option(searchResults.stream().flatMap(this::transformUser).collect(Collectors.toList()));
    }

    private Stream<PickerServiceDeskUserValue> transformUser(CheckedUser user) {
        return Lists.newArrayList((Iterator)io.atlassian.fugue.Option.option((Object)this.pickerServiceDeskUserValueFactory.getPickerServiceDeskUser(user.forJIRA())).iterator()).stream();
    }

    private io.atlassian.fugue.Option<Project> getProjectById(String projectIdStr, CheckedUser user) {
        return this.getLong(projectIdStr).flatMap(projectId -> this.serviceDeskProjectService.getProjectById(user, (Long)projectId).toOption());
    }

    private io.atlassian.fugue.Option<Long> getLong(String longString) {
        try {
            return io.atlassian.fugue.Option.some((Object)Long.parseLong(longString));
        }
        catch (NumberFormatException e) {
            return io.atlassian.fugue.Option.none();
        }
    }

    private io.atlassian.fugue.Option<Unit> hasPermissionToBrowseUsers(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        if (this.customerUserPickerPermissionService.canSearchAllUsersOfProject(user, project, serviceDesk) || this.customerUserPickerPermissionService.canSearchAnyOrganizations(user, project)) {
            return io.atlassian.fugue.Option.some((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Option.none();
    }
}

