/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.util.RedirectUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ExternalSSORedirectService {
    private static final String JIRA_STANDARD_LOGIN_URL = "/login.jsp?";
    private static final String JIRA_STANDARD_LOGOUT_URL = "/secure/Logout!default.jspa";

    public boolean isSSOAvailableForLogin() {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        String linkLoginURL = securityConfig.getLinkLoginURL();
        return !StringUtils.startsWith((String)linkLoginURL, (String)JIRA_STANDARD_LOGIN_URL);
    }

    public String getLoginUrl(HttpServletRequest request) {
        return RedirectUtils.getLinkLoginURL((HttpServletRequest)request);
    }

    public boolean isSSOAvailableForLogout() {
        String logoutURL = this.getLogoutUrl();
        return !StringUtils.equals((String)logoutURL, (String)JIRA_STANDARD_LOGOUT_URL) || this.isSSOAvailableForLogin();
    }

    public String getLogoutUrl() {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        return securityConfig.getLogoutURL();
    }
}

