/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.announcement.Announcement;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.AnnouncementWithWiki;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.requests.sharedportal.AnnouncementChange;
import com.atlassian.servicedesk.internal.rest.responses.AnnouncementResponse;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk-data/announcement")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AnnouncementResource {
    private final AnnouncementService announcementService;
    private final RestResponseHelper restResponseHelper;
    private final RichTextRenderer richTextRenderer;
    private final UserFactory userFactory;
    private final PortalInternalManager portalInternalManager;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final CommonErrors commonErrors;
    private final FeatureManager featureManager;

    public AnnouncementResource(AnnouncementService announcementService, RestResponseHelper restResponseHelper, RichTextRenderer richTextRenderer, UserFactory userFactory, PortalInternalManager portalInternalManager, ServiceDeskProjectService serviceDeskProjectService, CommonErrors commonErrors, FeatureManager featureManager) {
        this.announcementService = announcementService;
        this.restResponseHelper = restResponseHelper;
        this.richTextRenderer = richTextRenderer;
        this.userFactory = userFactory;
        this.portalInternalManager = portalInternalManager;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.commonErrors = commonErrors;
        this.featureManager = featureManager;
    }

    @POST
    @Path(value="help-center")
    public Response updateHelpCenterAnnouncement(AnnouncementChange announcementChange) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.announcementService.updateHelpCenterAnnouncement((CheckedUser)user, Announcement.builder().header(announcementChange.getHeader()).message(announcementChange.getMessage()).build())).yield((user, announcement) -> this.buildAnnouncementResponse((Announcement)announcement, (CheckedUser)user, (Option<Pair<Project, Portal>>)Option.none()));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="help-center")
    public Response getHelpCenterAnnouncement() {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.announcementService.getHelpCenterHeaderAnnouncement(user.asUncheckedUser())).yield((user, announcement) -> this.buildAnnouncementResponse((Announcement)announcement, (CheckedUser)user, (Option<Pair<Project, Portal>>)Option.none()));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="portal/{portalId}")
    public Response updatePortalAnnouncement(@PathParam(value="portalId") Long portalId, AnnouncementChange announcementChange) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_PROJECT_ANNOUNCEMENT)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.portalInternalManager.getPortalById(portalId)).then((user, portal) -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, portal.getProjectId())).then((user, portal, project) -> this.announcementService.updatePortalAnnouncement((CheckedUser)user, (Project)project, (Portal)portal, Announcement.builder().header(announcementChange.getHeader()).message(announcementChange.getMessage()).build())).yield((user, portal, project, announcement) -> this.buildAnnouncementResponse((Announcement)announcement, (CheckedUser)user, (Option<Pair<Project, Portal>>)Option.some((Object)Pair.pair((Object)project, (Object)portal))));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="portal/{portalId}")
    public Response getPortalAnnouncement(@PathParam(value="portalId") Long portalId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.portalInternalManager.getPortalById(portalId)).then((user, portal) -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, portal.getProjectId())).then((user, portal, project) -> this.announcementService.getPortalAnnouncement((CheckedUser)user, (Project)project, portalId)).yield((user, portal, project, announcement) -> this.buildAnnouncementResponse((Announcement)announcement, (CheckedUser)user, (Option<Pair<Project, Portal>>)Option.some((Object)Pair.pair((Object)project, (Object)portal))));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private AnnouncementResponse buildAnnouncementResponse(Announcement announcement, CheckedUser user, Option<Pair<Project, Portal>> projectPortalOption) {
        String header = announcement.getHeaderAsText();
        String headerWiki = new AnnouncementWithWiki(header, this.richTextRenderer.renderWiki(header, RenderOption.OPEN_LINKS_IN_NEW_TAB)).getWikiText();
        String message = announcement.getMessageAsText();
        String messageWiki = new AnnouncementWithWiki(message, this.richTextRenderer.renderWiki(message, RenderOption.OPEN_LINKS_IN_NEW_TAB)).getWikiText();
        boolean canEditAnnouncements = (Boolean)projectPortalOption.fold(() -> this.announcementService.canEditHelpCenterAnnouncement(user), pair -> this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_PROJECT_ANNOUNCEMENT) && this.announcementService.canEditPortalAnnouncement(user, (Portal)pair.right(), (Project)pair.left()));
        return new AnnouncementResponse(header, headerWiki, message, messageWiki, canEditAnnouncements, (Option<Portal>)projectPortalOption.map(Pair::right));
    }
}

