/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.requesttype.group;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.requesttype.group.PartialRequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import com.atlassian.servicedesk.internal.api.requesttype.group.SoftDeleteRequestTypeGroupResponse;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestTypeGroupServiceImpl
implements RequestTypeGroupService {
    private final RequestTypeGroupManager requestTypeGroupManager;
    private final UserFactory userFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ErrorResultHelper errorResultHelper;
    private final InternalPortalService internalPortalService;

    @Autowired
    public RequestTypeGroupServiceImpl(RequestTypeGroupManager requestTypeGroupManager, UserFactory userFactory, ServiceDeskPermissions serviceDeskPermissions, ErrorResultHelper errorResultHelper, InternalPortalService internalPortalService) {
        this.requestTypeGroupManager = requestTypeGroupManager;
        this.userFactory = userFactory;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.errorResultHelper = errorResultHelper;
        this.internalPortalService = internalPortalService;
    }

    public io.atlassian.fugue.Either<AnError, RequestTypeGroup> createGroup(CheckedUser user, PartialRequestTypeGroup partial, Project project, Portal portal) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return this.requestTypeGroupManager.addGroup(partial, portal);
        }
        return io.atlassian.fugue.Either.left((Object)this.notPermitted());
    }

    public io.atlassian.fugue.Either<AnError, RequestTypeGroup> getGroup(CheckedUser checkedUser, Project project, Portal portal, int groupId) {
        return Steps.begin(this.checkViewPermission(checkedUser, project)).then(permission -> this.requestTypeGroupManager.getGroup(groupId, portal)).yield((permission, group) -> group);
    }

    public io.atlassian.fugue.Either<AnError, RequestTypeGroup> updateGroupName(CheckedUser user, Project project, Portal portal, int groupId, String name) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return this.requestTypeGroupManager.updateGroupName(groupId, portal, name);
        }
        return io.atlassian.fugue.Either.left((Object)this.notPermitted());
    }

    public io.atlassian.fugue.Either<AnError, List<RequestTypeGroup>> getGroups(ApplicationUser user, Project project, Portal portal) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> this.checkViewPermission((CheckedUser)checkedUser, project)).then((checkedUser, permission) -> this.getGroupsEither(portal)).yield((checkedUser, permission, groups) -> groups);
    }

    public io.atlassian.fugue.Either<AnError, Map<Integer, List<Integer>>> getGroupToRequestTypeOrderMapping(CheckedUser checkedUser, Project project) {
        return Steps.begin(this.checkViewPermission(checkedUser, project)).then(permission -> this.internalPortalService.getPortalByProject(checkedUser, project)).yield((permission, portal) -> this.requestTypeGroupManager.getGroupToRequestTypeOrderMapping(portal.getId()));
    }

    public io.atlassian.fugue.Either<AnError, List<RequestTypeGroup>> updateGroupOrder(CheckedUser user, Project project, Portal portal, int[] order) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return this.requestTypeGroupManager.updateGroupOrder(portal, order);
        }
        return io.atlassian.fugue.Either.left((Object)this.notPermitted());
    }

    public io.atlassian.fugue.Either<AnError, SoftDeleteRequestTypeGroupResponse> softDeleteGroups(CheckedUser checkedUser, Project project, Portal portal, int[] groupsToDelete) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)checkedUser, project)) {
            return this.requestTypeGroupManager.softDeleteGroups(portal, groupsToDelete);
        }
        return io.atlassian.fugue.Either.left((Object)this.notPermitted());
    }

    public io.atlassian.fugue.Either<AnError, List<RequestTypeGroup>> undoGroupDeletes(CheckedUser checkedUser, Project project, Portal portal, long deleteTimestamp) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)checkedUser, project)) {
            return this.requestTypeGroupManager.undoGroupDeletes(portal, deleteTimestamp);
        }
        return io.atlassian.fugue.Either.left((Object)this.notPermitted());
    }

    private io.atlassian.fugue.Either<AnError, List<RequestTypeGroup>> getGroupsEither(Portal portal) {
        return io.atlassian.fugue.Either.right(this.requestTypeGroupManager.getGroups(portal));
    }

    private io.atlassian.fugue.Either<AnError, Boolean> checkViewPermission(CheckedUser checkedUser, Project project) {
        if (this.serviceDeskPermissions.canViewPortal((SDUser)checkedUser, project)) {
            return io.atlassian.fugue.Either.right((Object)Boolean.TRUE);
        }
        return io.atlassian.fugue.Either.left((Object)this.notPermitted());
    }

    private AnError notPermitted() {
        return this.errorResultHelper.forbidden403("sd.internal.portal.not-permitted", new Object[0]).build();
    }
}

