/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.requesttype.group;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.group.PartialRequestTypeGroup;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeGroupImpl;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeGroupQStore;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RequestTypeGroupQStoreImpl
implements RequestTypeGroupQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public RequestTypeGroupQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    private static ConstructorExpression<RequestTypeGroupImpl> MAPPER() {
        return Projections.constructor(RequestTypeGroupImpl.class, (Expression[])new Expression[]{Tables.REQUEST_TYPE_GROUP.ID, Tables.REQUEST_TYPE_GROUP.GROUP_NAME, Tables.REQUEST_TYPE_GROUP.ORDER});
    }

    @Override
    public Option<RequestTypeGroup> addGroup(PartialRequestTypeGroup partial, Portal portal) {
        Integer id = (Integer)this.databaseAccessor.run(conn -> (Integer)conn.insert((RelationalPath)Tables.REQUEST_TYPE_GROUP).set((Path)Tables.REQUEST_TYPE_GROUP.GROUP_NAME, (Object)partial.getName()).set(Tables.REQUEST_TYPE_GROUP.VIEWPORT_ID, (Object)portal.getId()).set(Tables.REQUEST_TYPE_GROUP.ORDER, partial.getOrder().getOrNull()).executeWithKey(Tables.REQUEST_TYPE_GROUP.ID));
        return this.getGroup(id, portal);
    }

    @Override
    public Option<RequestTypeGroup> getGroup(int groupId, Portal portal) {
        RequestTypeGroupImpl result = (RequestTypeGroupImpl)this.databaseAccessor.run(conn -> (RequestTypeGroupImpl)((SQLQuery)((SQLQuery)conn.select(RequestTypeGroupQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE_GROUP)).where((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq((Object)groupId).and((Predicate)Tables.REQUEST_TYPE_GROUP.VIEWPORT_ID.eq((Object)portal.getId())).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).fetchOne());
        return Option.option((Object)result);
    }

    @Override
    public Option<RequestTypeGroup> updateGroupName(int groupId, Portal portal, String name) {
        this.databaseAccessor.run(conn -> conn.update((RelationalPath)Tables.REQUEST_TYPE_GROUP).where((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq((Object)groupId).and((Predicate)Tables.REQUEST_TYPE_GROUP.VIEWPORT_ID.eq((Object)portal.getId()))).set((Path)Tables.REQUEST_TYPE_GROUP.GROUP_NAME, (Object)name).execute());
        return this.getGroup(groupId, portal);
    }

    @Override
    public List<RequestTypeGroup> getGroups(Portal portal) {
        List result = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeGroupQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE_GROUP)).where((Predicate)Tables.REQUEST_TYPE_GROUP.VIEWPORT_ID.eq((Object)portal.getId()).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).orderBy(Tables.REQUEST_TYPE_GROUP.ORDER.asc())).orderBy(Tables.REQUEST_TYPE_GROUP.GROUP_NAME.asc())).fetch());
        return new ArrayList<RequestTypeGroup>(result);
    }

    @Override
    public List<RequestTypeGroup> getGroupsForRequestType(int requestTypeId) {
        List result = (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(RequestTypeGroupQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE_GROUP)).innerJoin((EntityPath)Tables.GROUP_TO_REQUEST_TYPE)).on((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID))).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq((Object)requestTypeId).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).orderBy(Tables.REQUEST_TYPE_GROUP.ORDER.asc())).orderBy(Tables.REQUEST_TYPE_GROUP.GROUP_NAME.asc())).fetch());
        return new ArrayList<RequestTypeGroup>(result);
    }

    @Override
    public List<RequestTypeGroup> hardDeleteGroups(Portal portal) {
        List result = (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)conn.select(RequestTypeGroupQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE_GROUP)).where((Predicate)Tables.REQUEST_TYPE_GROUP.VIEWPORT_ID.eq((Object)portal.getId()))).fetch());
        this.databaseAccessor.run(conn -> conn.delete((RelationalPath)Tables.REQUEST_TYPE_GROUP).where((Predicate)Tables.REQUEST_TYPE_GROUP.VIEWPORT_ID.eq((Object)portal.getId())).execute());
        return new ArrayList<RequestTypeGroup>(result);
    }

    @Override
    public List<RequestTypeGroup> softDeleteGroups(List<Integer> groupIds, Long deletedTime) {
        this.databaseAccessor.run(conn -> conn.update((RelationalPath)Tables.REQUEST_TYPE_GROUP).set(Tables.REQUEST_TYPE_GROUP.DELETED_TIME, (Object)deletedTime).where((Predicate)Tables.REQUEST_TYPE_GROUP.ID.in((Collection)groupIds)).execute());
        List result = (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)conn.select(RequestTypeGroupQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE_GROUP)).where((Predicate)Tables.REQUEST_TYPE_GROUP.ID.in((Collection)groupIds))).fetch());
        return new ArrayList<RequestTypeGroup>(result);
    }

    @Override
    public void updateGroupOrders(List<RequestTypeGroup> groups) {
        this.databaseAccessor.runInTransaction(conn -> {
            for (RequestTypeGroup rtg : groups) {
                conn.update((RelationalPath)Tables.REQUEST_TYPE_GROUP).set(Tables.REQUEST_TYPE_GROUP.ORDER, rtg.getOrder().getOrElse((Object)0)).where((Predicate)Tables.REQUEST_TYPE_GROUP.ID.eq((Object)rtg.getId())).execute();
            }
            return conn;
        });
    }

    @Override
    public List<RequestTypeGroup> restoreGroupsWith(long deleteTimestamp) {
        List result = (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)conn.select(RequestTypeGroupQStoreImpl.MAPPER()).from((Expression)Tables.REQUEST_TYPE_GROUP)).where((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.eq((Object)deleteTimestamp))).fetch());
        this.databaseAccessor.run(conn -> conn.update((RelationalPath)Tables.REQUEST_TYPE_GROUP).setNull(Tables.REQUEST_TYPE_GROUP.DELETED_TIME).where((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.eq((Object)deleteTimestamp)).execute());
        return new ArrayList<RequestTypeGroup>(result);
    }
}

