/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.requesttype.group;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.internal.time.EpochTimeProvider;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.api.requesttype.group.PartialRequestTypeGroup;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.api.requesttype.group.SoftDeleteRequestTypeGroupResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeQStore;
import com.atlassian.servicedesk.internal.requesttype.group.GroupOrderHelper;
import com.atlassian.servicedesk.internal.requesttype.group.GroupToRequestTypeQStore;
import com.atlassian.servicedesk.internal.requesttype.group.GroupValidator;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeGroupQStore;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeOrderHelper;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeGroupManagerImpl
implements RequestTypeGroupManager {
    private final RequestTypeGroupQStore requestTypeGroupQStore;
    private final RequestTypeQStore requestTypeQStore;
    private final GroupToRequestTypeQStore groupToRequestTypeQStore;
    private final ErrorResultHelper errorResultHelper;
    private final EpochTimeProvider epochTimeProvider;
    private final GroupValidator groupValidator;

    @Autowired
    public RequestTypeGroupManagerImpl(RequestTypeGroupQStore requestTypeGroupQStore, RequestTypeQStore requestTypeQStore, GroupToRequestTypeQStore groupToRequestTypeQStore, ErrorResultHelper errorResultHelper, EpochTimeProvider epochTimeProvider, GroupValidator groupValidator) {
        this.requestTypeGroupQStore = requestTypeGroupQStore;
        this.requestTypeQStore = requestTypeQStore;
        this.groupToRequestTypeQStore = groupToRequestTypeQStore;
        this.errorResultHelper = errorResultHelper;
        this.epochTimeProvider = epochTimeProvider;
        this.groupValidator = groupValidator;
    }

    @Override
    public Either<AnError, RequestTypeGroup> addGroup(PartialRequestTypeGroup partial, Portal portal) {
        AnError validationResult = this.groupValidator.validateGroupName(partial.getName(), portal);
        if (validationResult != null) {
            return Either.left((Object)validationResult);
        }
        Option<RequestTypeGroup> group = this.requestTypeGroupQStore.addGroup(partial = partial.withOrder(this.verifyGroupOrder(portal)), portal);
        if (group.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.internal.requestype.group.error.insert", new Object[0]).build());
        }
        return Either.right((Object)group.get());
    }

    private int verifyGroupOrder(Portal portal) {
        List<RequestTypeGroup> groups = this.requestTypeGroupQStore.getGroups(portal);
        if (groups.stream().anyMatch(group -> group.getOrder().isEmpty())) {
            this.saveGroupsInThisOrder(GroupOrderHelper.assignOrder(groups));
        }
        return groups.size();
    }

    private void saveGroupsInThisOrder(List<RequestTypeGroup> groups) {
        this.requestTypeGroupQStore.updateGroupOrders(groups);
    }

    @Override
    public Either<AnError, RequestTypeGroup> getGroup(int groupId, Portal portal) {
        Option<RequestTypeGroup> group = this.requestTypeGroupQStore.getGroup(groupId, portal);
        if (group.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.notFound404("sd.internal.requestype.group.error.not-found", new Object[0]).build());
        }
        return Either.right((Object)group.get());
    }

    @Override
    public Either<AnError, RequestTypeGroup> updateGroupName(int groupId, Portal portal, String name) {
        AnError validationResult = this.groupValidator.validateGroupName(name, portal);
        if (validationResult != null) {
            return Either.left((Object)validationResult);
        }
        this.verifyGroupOrder(portal);
        Option<RequestTypeGroup> group = this.requestTypeGroupQStore.updateGroupName(groupId, portal, name);
        if (group.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.notFound404("sd.internal.requestype.group.error.not-found", new Object[0]).build());
        }
        return Either.right((Object)group.get());
    }

    @Override
    public List<RequestTypeGroup> getGroups(Portal portal) {
        return this.requestTypeGroupQStore.getGroups(portal);
    }

    @Override
    public List<RequestTypeGroup> getGroupsForRequestType(RequestType requestType) {
        return this.getGroupsForRequestType(requestType.getId());
    }

    @Override
    public List<RequestTypeInternal> getRequestTypesInGroupSorted(int groupId, long projectId) {
        List<RequestTypeInternal> unsorted = this.requestTypeQStore.getRequestTypesInGroup(groupId, projectId);
        if (unsorted.isEmpty()) {
            return unsorted;
        }
        List<Integer> requestTypeIDs = this.groupToRequestTypeQStore.getRequestTypeIDsInSortedOrderForGroup(groupId);
        ArrayList<RequestTypeInternal> sorted = new ArrayList<RequestTypeInternal>(unsorted.size());
        for (int requestTypeID : requestTypeIDs) {
            sorted.add(unsorted.stream().filter(rt -> rt.getId() == requestTypeID).findFirst().get());
        }
        return sorted;
    }

    @Override
    public List<RequestTypeGroup> deleteGroups(Portal portal) {
        return this.requestTypeGroupQStore.hardDeleteGroups(portal);
    }

    @Override
    public void associateGroupsToRequestType(RequestType requestType, List<RequestTypeGroup> groups) {
        List<RequestTypeGroup> currentGroups = this.getGroupsForRequestType(requestType.getId());
        List currentIds = currentGroups.stream().map(requestTypeGroup -> requestTypeGroup.getId()).collect(Collectors.toList());
        for (RequestTypeGroup group : groups) {
            if (currentIds.contains(group.getId())) continue;
            this.groupToRequestTypeQStore.associateGroupToRequestType(requestType.getId(), group.getId());
        }
    }

    @Override
    public Either<AnError, RequestTypeInternal> moveRequestTypeInGroup(int requestTypeId, long projectId, int groupId, Option<Integer> aboveId) {
        int index;
        List<RequestTypeInternal> requestTypes = this.getRequestTypesInGroupSorted(groupId, projectId);
        ArrayList<RequestTypeInternal> arrayList = new ArrayList<RequestTypeInternal>(requestTypes);
        RequestTypeInternal toMove = null;
        for (index = 0; index < arrayList.size() && toMove == null; ++index) {
            if (arrayList.get(index).getId() != requestTypeId) continue;
            toMove = arrayList.remove(index);
        }
        if (toMove == null) {
            return Either.left((Object)this.errorResultHelper.notFound404("sd.internal.requestype.group.error.not-found", new Object[0]).build());
        }
        if (aboveId.isEmpty()) {
            arrayList.add(0, toMove);
        } else {
            boolean found = false;
            for (index = 0; index < arrayList.size() && !found; ++index) {
                if (arrayList.get(index).getId() != ((Integer)aboveId.get()).intValue()) continue;
                arrayList.add(index + 1, toMove);
                found = true;
            }
            if (!found) {
                return Either.left((Object)this.errorResultHelper.notFound404("sd.internal.requestype.group.error.not-in-group", new Object[0]).build());
            }
        }
        this.groupToRequestTypeQStore.updateOrderForRequestTypesInGroup(arrayList, groupId);
        return Either.right((Object)toMove);
    }

    @Override
    public void mapRequestTypeToGroups(int requestTypeId, List<Integer> groupIds, Project project) {
        List<Integer> currentIds = this.getGroupsForRequestType(requestTypeId).stream().map(requestTypeGroup -> requestTypeGroup.getId()).collect(Collectors.toList());
        this.removeFromGroups(requestTypeId, groupIds, currentIds);
        this.addToNewGroups(requestTypeId, groupIds, project, currentIds);
    }

    private void removeFromGroups(int requestTypeId, List<Integer> groupIds, List<Integer> currentIds) {
        for (Integer currentId : currentIds) {
            if (groupIds.contains(currentId)) continue;
            this.groupToRequestTypeQStore.disassociateGroupToRequestType(requestTypeId, currentId);
        }
    }

    private void addToNewGroups(int requestTypeId, List<Integer> groupIds, Project project, List<Integer> currentIds) {
        for (Integer groupId : groupIds) {
            if (currentIds.contains(groupId)) continue;
            this.groupToRequestTypeQStore.associateGroupToRequestType(requestTypeId, groupId);
            this.addToTheEndOfTheGroup(requestTypeId, project.getId().intValue(), groupId);
        }
    }

    private void addToTheEndOfTheGroup(int requestTypeId, int projectId, Integer groupId) {
        List<RequestTypeInternal> requestTypesInGroup = this.getRequestTypesInGroupSorted(groupId, projectId);
        this.moveRequestTypeInGroup(requestTypeId, projectId, groupId, RequestTypeOrderHelper.getLastSortedIdExcludingCurrentId(requestTypeId, requestTypesInGroup));
    }

    private List<RequestTypeGroup> getGroupsForRequestType(int requestTypeId) {
        return this.requestTypeGroupQStore.getGroupsForRequestType(requestTypeId);
    }

    @Override
    public Map<Integer, List<Integer>> getGroupToRequestTypeOrderMapping(int portalId) {
        return this.groupToRequestTypeQStore.getGroupToRequestTypeOrderMapping(portalId);
    }

    @Override
    public Either<AnError, List<RequestTypeGroup>> updateGroupOrder(Portal portal, int[] order) {
        if (order == null || order.length == 0) {
            return Either.right((Object)Lists.newArrayList());
        }
        this.verifyGroupOrder(portal);
        List<RequestTypeGroup> groups = this.requestTypeGroupQStore.getGroups(portal);
        Either<AnError, List<RequestTypeGroup>> result = GroupOrderHelper.reorderGroups(groups, order, this.errorResultHelper);
        if (result.isRight()) {
            List orderedGroups = (List)result.right().get();
            this.saveGroupsInThisOrder(orderedGroups);
            return Either.right((Object)orderedGroups);
        }
        return result;
    }

    @Override
    public Either<AnError, SoftDeleteRequestTypeGroupResponse> softDeleteGroups(Portal portal, int[] toDelete) {
        long time = this.epochTimeProvider.getEpochTime();
        if (toDelete == null || toDelete.length == 0) {
            return Either.right((Object)new SoftDeleteRequestTypeGroupResponse((List)Lists.newArrayList(), time));
        }
        List<Integer> toDeleteList = Arrays.stream(toDelete).boxed().collect(Collectors.toList());
        List<RequestTypeGroup> existingGroups = this.requestTypeGroupQStore.getGroups(portal);
        boolean allValidIds = toDeleteList.stream().allMatch(i -> existingGroups.stream().anyMatch(r -> i.equals(r.getId())));
        return Eithers.cond((boolean)allValidIds, (Object)this.errorResultHelper.badRequest400("sd.internal.requestype.group.delete.error.invalid-ids", new Object[0]).build(), (Object)new SoftDeleteRequestTypeGroupResponse(this.requestTypeGroupQStore.softDeleteGroups(toDeleteList, time), time));
    }

    @Override
    public Either<AnError, List<RequestTypeGroup>> undoGroupDeletes(Portal portal, long deleteTimestamp) {
        if (deleteTimestamp < 0L || deleteTimestamp > this.epochTimeProvider.getEpochTime()) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.internal.requestype.group.undo-delete.invalid-timestamp", new Object[0]).build());
        }
        return Either.right(this.requestTypeGroupQStore.restoreGroupsWith(deleteTimestamp));
    }
}

