/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.project.type;

import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreatedData;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.project.type.ServiceDeskProjectType;
import com.atlassian.servicedesk.internal.project.type.ServiceDeskProjectHelper;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class ServiceDeskProjectCreateHandler
implements ProjectCreateHandler {
    private static final String SD_PROJECT_CREATE_HANDLER_ID = "servicedesk-project-create-handler";
    private final ServiceDeskProjectHelper sdProjectHelper;

    @Autowired
    public ServiceDeskProjectCreateHandler(ServiceDeskProjectHelper sdProjectHelper) {
        this.sdProjectHelper = sdProjectHelper;
    }

    public String getHandlerId() {
        return SD_PROJECT_CREATE_HANDLER_ID;
    }

    public void onProjectCreated(ProjectCreatedData projectCreatedData) throws CreateException {
        Either<AnError, Boolean> sdResult;
        if ((this.isSharedConfigServiceDeskProject(projectCreatedData) || this.isServiceDeskProjectWithoutTemplate(projectCreatedData)) && (sdResult = this.sdProjectHelper.createServiceDeskForSharedConfigProject(projectCreatedData.getProject())).isLeft()) {
            throw new CreateException("Failed to create service desk.");
        }
    }

    public void onProjectCreationRolledBack(ProjectCreatedData projectCreatedData) {
        if (this.isSharedConfigServiceDeskProject(projectCreatedData)) {
            this.sdProjectHelper.deleteServiceDesk(projectCreatedData.getProject());
        }
    }

    private boolean isSharedConfigServiceDeskProject(ProjectCreatedData projectCreatedData) {
        return this.isServiceDeskProject(projectCreatedData.getProject()) && projectCreatedData.getType() == ProjectCreatedData.Type.CREATE_WITH_SHARED_CONFIG;
    }

    private boolean isServiceDeskProjectWithoutTemplate(ProjectCreatedData projectCreatedData) {
        return this.isServiceDeskProject(projectCreatedData.getProject()) && !projectCreatedData.getProjectTemplateKey().isPresent();
    }

    private boolean isServiceDeskProject(Project project) {
        return project.getProjectTypeKey().equals((Object)ServiceDeskProjectType.KEY);
    }
}

