/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.project;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.internal.errors.I18nErrorMessage;
import com.atlassian.servicedesk.internal.errors.ServiceDeskError;
import com.atlassian.servicedesk.internal.feature.gettingstarted.GettingStartedService;
import com.atlassian.servicedesk.internal.feature.gettingstarted.ServiceDeskProjectTemplateType;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.project.CreatedServiceDeskResult;
import com.atlassian.servicedesk.internal.utils.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskProjectConfigurator {
    @Autowired
    private GettingStartedService gettingStartedService;
    @Autowired
    private UserFactory userFactory;
    @Autowired
    private UserProjectHistoryManager userProjectHistoryManager;
    @Autowired
    private ErrorResultHelper errorResultHelper;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskProjectConfigurator.class);

    public boolean configure(Project project, ServiceDeskProjectTemplateType serviceDeskType) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.callGettingStartedServiceToCreateServiceDesk((CheckedUser)checkedUser, project, serviceDeskType)).then(this::doProjectCreationSideEffects).yield((a, b, c) -> true);
        if (result.isLeft()) {
            log.warn(((AnError)result.left().get()).getMessage().getMessage());
        }
        return result.isRight();
    }

    private io.atlassian.fugue.Either<AnError, CreatedServiceDeskResult> callGettingStartedServiceToCreateServiceDesk(CheckedUser user, Project project, ServiceDeskProjectTemplateType serviceDeskType) {
        io.atlassian.fugue.Either<ServiceDeskError, CreatedServiceDeskResult> callResult = Convert.toJavaEither(this.gettingStartedService.createServiceDeskForEmptyProject(user, project, serviceDeskType));
        io.atlassian.fugue.Either foldResult2 = (io.atlassian.fugue.Either)callResult.fold(this::foldErrorWithType, io.atlassian.fugue.Either::right);
        return foldResult2;
    }

    private io.atlassian.fugue.Either<AnError, CreatedServiceDeskResult> foldErrorWithType(ServiceDeskError sdError) {
        I18nErrorMessage message = sdError.firstErrorMessage();
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(500, message.i18nKey(), new Object[]{message.args()}));
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> doProjectCreationSideEffects(CheckedUser user, CreatedServiceDeskResult result) {
        Project project;
        io.atlassian.fugue.Either createSpaceResult;
        this.userProjectHistoryManager.addProjectToHistory(user.forJIRA(), result.getProject());
        if (this.featureManager.isEnabled(SDFeatureFlags.PROJECT_CREATION_CREATE_AND_LINK_KB_SPACE) && (createSpaceResult = this.confluenceKnowledgeBaseService.generateAndLinkSpace(user, project = result.getProject())).isLeft()) {
            log.error("Error automatically creating a linked Confluence Knowledge Base space upon project creation: {}", (Object)((AnError)createSpaceResult.left().get()).getMessage());
        }
        return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
    }
}

