/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.permission.security.type.CustomerPortalOnlyPermissionChecker;
import com.atlassian.servicedesk.internal.permission.security.type.CustomerPortalOnlySecurityType;
import com.atlassian.servicedesk.internal.permission.security.type.CustomerPortalOnlySecurityTypeImpl;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSecurityTypeInstaller {
    private final I18nHelper i18nHelper;
    private final CustomerPortalOnlyPermissionChecker customerPortalOnlyPermissionChecker;

    @Autowired
    public ServiceDeskSecurityTypeInstaller(I18nHelper i18nHelper, CustomerPortalOnlyPermissionChecker customerPortalOnlyPermissionChecker) {
        this.i18nHelper = i18nHelper;
        this.customerPortalOnlyPermissionChecker = customerPortalOnlyPermissionChecker;
    }

    public void install() {
        PermissionTypeManager permissionTypeManager = this.getPermissionTypeManager();
        SecurityTypeManager securityTypeManager = this.getSecurityTypeManager();
        CustomerPortalOnlySecurityTypeImpl securityType = new CustomerPortalOnlySecurityTypeImpl(this.i18nHelper, this.customerPortalOnlyPermissionChecker);
        this.addPermissionType(securityTypeManager, securityType);
        this.addPermissionType((SecurityTypeManager)permissionTypeManager, securityType);
    }

    public void uninstall() {
        PermissionTypeManager permissionTypeManager = this.getPermissionTypeManager();
        SecurityTypeManager securityTypeManager = this.getSecurityTypeManager();
        this.removePermissionType((SecurityTypeManager)permissionTypeManager);
        this.removePermissionType(securityTypeManager);
    }

    private void addPermissionType(SecurityTypeManager securityTypeManager, CustomerPortalOnlySecurityType customerPortalOnlySecurityType) {
        HashMap<String, CustomerPortalOnlySecurityType> securityTypes = new HashMap<String, CustomerPortalOnlySecurityType>(securityTypeManager.getTypes());
        securityTypes.put("sd.customer.portal.only", customerPortalOnlySecurityType);
        securityTypeManager.setSecurityTypes(securityTypes);
    }

    private void removePermissionType(SecurityTypeManager securityTypeManager) {
        HashMap securityTypes = new HashMap(securityTypeManager.getTypes());
        securityTypes.remove("sd.customer.portal.only");
        securityTypeManager.setSecurityTypes(securityTypes);
    }

    private PermissionTypeManager getPermissionTypeManager() {
        return (PermissionTypeManager)ComponentAccessor.getComponent(PermissionTypeManager.class);
    }

    private SecurityTypeManager getSecurityTypeManager() {
        return (SecurityTypeManager)ComponentAccessor.getComponent(SecurityTypeManager.class);
    }
}

