/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.permission.security.type.CustomerPortalOnlyPermissionChecker;
import com.atlassian.servicedesk.internal.permission.security.type.CustomerPortalOnlySecurityType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerPortalOnlySecurityTypeImpl
extends AbstractProjectsSecurityType
implements CustomerPortalOnlySecurityType {
    private static final Logger log = LoggerFactory.getLogger(CustomerPortalOnlySecurityTypeImpl.class);
    private static final String DISPLAY_NAME = "sd.permission.security.type.display";
    private static final ProjectPermissionKey[] RELEVANT_PERMISSIONS = new ProjectPermissionKey[]{ProjectPermissions.BROWSE_PROJECTS, ProjectPermissions.CREATE_ISSUES, ProjectPermissions.ADD_COMMENTS, ProjectPermissions.CREATE_ATTACHMENTS, ProjectPermissions.TRANSITION_ISSUES, ProjectPermissions.ASSIGN_ISSUES, ProjectPermissions.LINK_ISSUES, ProjectPermissions.SCHEDULE_ISSUES, ProjectPermissions.SET_ISSUE_SECURITY, ProjectPermissions.EDIT_ISSUES, ProjectPermissions.MOVE_ISSUES, ProjectPermissions.RESOLVE_ISSUES, ProjectPermissions.CLOSE_ISSUES, ProjectPermissions.MODIFY_REPORTER, ProjectPermissions.DELETE_ISSUES, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, ProjectPermissions.MANAGE_WATCHERS, ProjectPermissions.EDIT_OWN_COMMENTS, ProjectPermissions.DELETE_OWN_COMMENTS, ProjectPermissions.DELETE_OWN_ATTACHMENTS};
    private final I18nHelper i18nHelper;
    private final CustomerPortalOnlyPermissionChecker customerPortalOnlyPermissionChecker;

    public CustomerPortalOnlySecurityTypeImpl(I18nHelper i18nHelper, CustomerPortalOnlyPermissionChecker customerPortalOnlyPermissionChecker) {
        this.i18nHelper = i18nHelper;
        this.customerPortalOnlyPermissionChecker = customerPortalOnlyPermissionChecker;
    }

    public String getDisplayName() {
        return this.i18nHelper.getText(DISPLAY_NAME);
    }

    public String getType() {
        return "sd.customer.portal.only";
    }

    public boolean isValidForPermission(ProjectPermissionKey permissionKey) {
        for (ProjectPermissionKey permission : RELEVANT_PERMISSIONS) {
            if (!permission.equals((Object)permissionKey)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.customerPortalOnlyPermissionChecker.hasCustomerPortalOnlyPermission(user, project);
    }

    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.customerPortalOnlyPermissionChecker.hasCustomerPortalOnlyPermission(user, issue);
    }

    public Set<ApplicationUser> getUsers(PermissionContext permissionContext, String argument) {
        Project project = permissionContext.getProjectObject();
        if (project == null) {
            log.warn("returning no users because project in the permission context was null");
            return Collections.emptySet();
        }
        return this.customerPortalOnlyPermissionChecker.getCustomerPortalOnlyPermissionUsers(project);
    }

    public void doValidation(String key, Map<String, String> parameters, JiraServiceContext jiraServiceContext) {
    }

    public boolean hasPermission(Project project, String parameter) {
        return false;
    }

    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }
}

