/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security.type;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.permission.security.RequestAccessUserStrategyManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import com.atlassian.servicedesk.internal.utils.context.ServiceDeskOutsideCustomerPermissionContext;
import io.atlassian.fugue.Suppliers;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerPortalOnlyPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(CustomerPortalOnlyPermissionChecker.class);
    private final UserFactory userFactory;
    private final ServiceDeskJiraRoleManager serviceDeskJIRARoleManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final InternalServiceDeskAccessManager internalServiceDeskAccessManager;
    private final RequestAccessUserStrategyManager requestAccessUserStrategyManager;
    private final CustomerContextService customerContextService;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;
    private final UserManager userManager;
    private final ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext;
    private final FeatureManager featureManager;

    @Autowired
    public CustomerPortalOnlyPermissionChecker(CustomerContextService customerContextService, UserFactory userFactory, ServiceDeskJiraRoleManager serviceDeskJIRARoleManager, ServiceDeskInternalManager serviceDeskManager, InternalServiceDeskAccessManager internalServiceDeskAccessManager, RequestAccessUserStrategyManager requestAccessUserStrategyManager, CustomerOrganizationMemberManager customerOrganizationMemberManager, UserManager userManager, ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext, FeatureManager featureManager) {
        this.customerContextService = customerContextService;
        this.userFactory = userFactory;
        this.serviceDeskJIRARoleManager = serviceDeskJIRARoleManager;
        this.serviceDeskManager = serviceDeskManager;
        this.internalServiceDeskAccessManager = internalServiceDeskAccessManager;
        this.requestAccessUserStrategyManager = requestAccessUserStrategyManager;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
        this.userManager = userManager;
        this.serviceDeskOutsideCustomerPermissionContext = serviceDeskOutsideCustomerPermissionContext;
        this.featureManager = featureManager;
    }

    public Set<ApplicationUser> getCustomerPortalOnlyPermissionUsers(Project project) {
        if (!this.featureManager.isEnabled(ServiceDeskFeatureFlags.USE_SEARCH_BY_PERMISSIONS)) {
            return Collections.emptySet();
        }
        if (!this.customerContextService.isInCustomerContext()) {
            return Collections.emptySet();
        }
        if (this.isOpenAccess(project)) {
            log.warn("This call is going to return all users on your instance. Better to check if Service Desk is open access first, and avoid this call. Use debug logging to see this call stack");
            log.debug("Current call stack that is asking to return all users on your instance", (Throwable)new Exception());
            return this.userManager.getAllUsers();
        }
        return Stream.concat(this.serviceDeskJIRARoleManager.getAllUsersInRole(project, ServiceDeskProjectRole.CUSTOMER).stream(), this.getOrganizationMembersForProject(project)).distinct().collect(Collectors.toSet());
    }

    public boolean hasCustomerPortalOnlyPermission(ApplicationUser user, Issue issue) {
        return this.hasCustomerPortalOnlyPermissionForIssue(user, issue);
    }

    public boolean hasCustomerPortalOnlyPermission(ApplicationUser user, Project project) {
        return this.hasCustomerPortalOnlyPermissionForProject(user, project);
    }

    private boolean hasCustomerPortalOnlyPermissionForIssue(ApplicationUser user, Issue issue) {
        if (this.requestAccessUserStrategyManager.match(user, issue)) {
            return this.hasCustomerPortalOnlyPermissionForProject(user, issue.getProjectObject());
        }
        return false;
    }

    private boolean hasCustomerPortalOnlyPermissionForProject(ApplicationUser user, Project project) {
        return (Boolean)StepsConverters.newerEither((Either)this.userFactory.wrap(user)).map(checkedUser -> this.customerContextService.isInCustomerContext() && this.allowUserToAccessPortal((CheckedUser)checkedUser, project)).getOr(Suppliers.alwaysFalse());
    }

    private boolean allowUserToAccessPortal(CheckedUser checkedUser, Project project) {
        return this.isOpenAccess(project) || this.serviceDeskJIRARoleManager.isUserInRole(checkedUser, project, ServiceDeskProjectRole.CUSTOMER) || this.isMemberOfAnyOrganisationsInProject(checkedUser, project) || this.serviceDeskOutsideCustomerPermissionContext.isInProjectOutsideCustomerContext(checkedUser, project);
    }

    private boolean isOpenAccess(Project project) {
        io.atlassian.fugue.Either<AnError, ServiceDesk> serviceDeskEither = this.serviceDeskManager.getServiceDesk(project, false);
        return serviceDeskEither.exists(this.internalServiceDeskAccessManager::isOpenAccess);
    }

    private boolean isMemberOfAnyOrganisationsInProject(CheckedUser checkedUser, Project project) {
        return this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS) && this.customerOrganizationMemberManager.isMemberOfAnyOrganizationsInProject(checkedUser, project);
    }

    private Stream<ApplicationUser> getOrganizationMembersForProject(Project project) {
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.customerOrganizationMemberManager.getOrganizationMembersForProject(project).stream();
        }
        return Stream.empty();
    }
}

