/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.permission.security.RequestAccessUserStrategyManager;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CustomerInvolvedServiceImpl
implements CustomerInvolvedService {
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerContextService customerContextService;
    private final RequestAccessUserStrategyManager requestAccessUserStrategyManager;

    @Autowired
    public CustomerInvolvedServiceImpl(ServiceDeskPermissions serviceDeskPermissions, CustomerContextService customerContextService, RequestAccessUserStrategyManager requestAccessUserStrategyManager) {
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerContextService = customerContextService;
        this.requestAccessUserStrategyManager = requestAccessUserStrategyManager;
    }

    public List<CheckedUser> getMembers(Issue issue) {
        List<CheckedUser> members = this.requestAccessUserStrategyManager.getMembers(issue);
        return this.filterPermissions(issue, members);
    }

    public List<CheckedUser> getMembersForTypes(Issue issue, CustomerInvolvedType ... types) {
        List<CheckedUser> members = this.requestAccessUserStrategyManager.getMembersForTypes(issue, types);
        return this.filterPermissions(issue, members);
    }

    private List<CheckedUser> filterPermissions(Issue issue, List<CheckedUser> users) {
        List checkedPermissionsUsers = users.stream().filter(user -> this.hasAccessToRequest((CheckedUser)user, issue)).collect(Collectors.toList());
        return ImmutableList.copyOf(checkedPermissionsUsers);
    }

    public boolean hasAccessToRequest(CheckedUser user, Issue issue) {
        Project project = issue.getProjectObject();
        if (project == null) {
            return false;
        }
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.requestAccessUserStrategyManager.match(user.forJIRA(), issue) && this.serviceDeskPermissions.canCreateRequest((SDUser)user, project) && this.serviceDeskPermissions.canViewRequestInPortal((SDUser)user, issue));
    }

    public boolean isUserOfType(CheckedUser user, Issue issue, CustomerInvolvedType ... types) {
        Project project = issue.getProjectObject();
        if (project == null) {
            return false;
        }
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.requestAccessUserStrategyManager.match(user.forJIRA(), issue, types) && this.serviceDeskPermissions.canCreateRequest((SDUser)user, project) && this.serviceDeskPermissions.canViewRequestInPortal((SDUser)user, issue));
    }
}

