/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.outsider;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import io.atlassian.fugue.Suppliers;
import io.atlassian.fugue.Unit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@ExportAsService
@Component
public class OutsiderPermissionCheckerImpl
implements OutsiderPermissionChecker {
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final CustomerInvolvedService customerInvolvedService;
    private final UserFactory userFactory;
    private final CustomerContextService customerContextService;
    private final CommonErrors commonErrors;
    private final FeatureManager featureManager;

    @Autowired
    public OutsiderPermissionCheckerImpl(ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, CustomerInvolvedService customerInvolvedService, UserFactory userFactory, CustomerContextService customerContextService, CommonErrors commonErrors, FeatureManager featureManager) {
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.customerInvolvedService = customerInvolvedService;
        this.userFactory = userFactory;
        this.customerContextService = customerContextService;
        this.commonErrors = commonErrors;
        this.featureManager = featureManager;
    }

    public io.atlassian.fugue.Either<AnError, Unit> checkFeatureEnabled() {
        if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    public io.atlassian.fugue.Either<AnError, Boolean> isUserAnOutsiderEither(@Nullable ApplicationUser applicationUser, Issue issue) {
        return this.doIsUserAnOutsider(applicationUser, issue, true);
    }

    public boolean isUserAnOutsider(@Nullable ApplicationUser applicationUser, Issue issue) {
        return this.isUserAnOutsider(applicationUser, issue, true);
    }

    public boolean isUserAnOutsider(@Nullable ApplicationUser applicationUser, Issue issue, boolean includeFeatureFlagCheck) {
        return (Boolean)this.doIsUserAnOutsider(applicationUser, issue, includeFeatureFlagCheck).getOr(Suppliers.alwaysFalse());
    }

    private io.atlassian.fugue.Either<AnError, Boolean> doIsUserAnOutsider(@Nullable ApplicationUser applicationUser, Issue issue, boolean includeFeatureFlagCheck) {
        return StepsConverters.newerEither((Either)this.userFactory.wrap(applicationUser)).flatMap(checkedUser -> this.doIsUserAnOutsider((CheckedUser)checkedUser, issue, includeFeatureFlagCheck));
    }

    public boolean isUserAnOutsider(CheckedUser checkedUser, Issue issue) {
        return (Boolean)this.doIsUserAnOutsider(checkedUser, issue, true).getOr(Suppliers.alwaysFalse());
    }

    private io.atlassian.fugue.Either<AnError, Boolean> doIsUserAnOutsider(CheckedUser checkedUser, Issue issue, boolean includeFeatureFlagCheck) {
        if (includeFeatureFlagCheck && !this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return io.atlassian.fugue.Either.right((Object)(this.customerInvolvedService.isUserOfType(checkedUser, issue, new CustomerInvolvedType[]{CustomerInvolvedType.CUSTOMER_OUTSIDER}) || (Boolean)this.customerContextService.runInCustomerContext(() -> !this.serviceDeskLicenseAndPermissionService.canViewRequestInPortal((SDUser)checkedUser, issue)) != false && (Boolean)this.customerContextService.runOutOfCustomerContext(() -> !this.serviceDeskLicenseAndPermissionService.canViewIssue((SDUser)checkedUser, issue)) != false ? 1 : 0));
    }
}

