/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.misconfiguration.error;

import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.servicedesk.internal.permission.misconfiguration.Severity;
import java.util.List;
import java.util.Set;

public abstract class MisconfigurationInformation {
    private final String errorMessageKey;
    private final List<String> projectPermissionNames;
    private final Severity severity;
    private final Set<ProjectPermissionKey> projectPermissionKeys;

    public MisconfigurationInformation(String errorMessageKey, List<String> projectPermissionNames, Severity severity, Set<ProjectPermissionKey> projectPermissionKeys) {
        this.errorMessageKey = errorMessageKey;
        this.projectPermissionNames = projectPermissionNames;
        this.severity = severity;
        this.projectPermissionKeys = projectPermissionKeys;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Set<ProjectPermissionKey> getProjectPermissionKeys() {
        return this.projectPermissionKeys;
    }

    public String getErrorMessageKey() {
        return this.errorMessageKey;
    }

    public List<String> getProjectPermissionNames() {
        return this.projectPermissionNames;
    }

    public String getReasonKey() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MisconfigurationInformation that = (MisconfigurationInformation)o;
        if (this.errorMessageKey != null ? !this.errorMessageKey.equals(that.errorMessageKey) : that.errorMessageKey != null) {
            return false;
        }
        if (this.projectPermissionNames != null ? !this.projectPermissionNames.equals(that.projectPermissionNames) : that.projectPermissionNames != null) {
            return false;
        }
        if (this.severity != that.severity) {
            return false;
        }
        return this.projectPermissionKeys != null ? this.projectPermissionKeys.equals(that.projectPermissionKeys) : that.projectPermissionKeys == null;
    }

    public int hashCode() {
        int result = this.errorMessageKey != null ? this.errorMessageKey.hashCode() : 0;
        result = 31 * result + (this.projectPermissionNames != null ? this.projectPermissionNames.hashCode() : 0);
        result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
        result = 31 * result + (this.projectPermissionKeys != null ? this.projectPermissionKeys.hashCode() : 0);
        return result;
    }
}

