/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.group;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.permission.group.ServiceDeskAgentPermissionManager;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.atlassian.servicedesk.squalor.permission.PermissionShim;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskAgentPermissionManagerImpl
implements ServiceDeskAgentPermissionManager {
    private static final Comparator<ApplicationUser> USER_COMPARATOR = new Comparator<ApplicationUser>(){

        @Override
        public int compare(ApplicationUser user1, ApplicationUser user2) {
            return user1.getKey().compareTo(user2.getKey());
        }
    };
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupManager groupManager;
    private final PermissionShim permissionShim;
    private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;

    @Autowired
    public ServiceDeskAgentPermissionManagerImpl(GlobalPermissionManager globalPermissionManager, GroupManager groupManager, PermissionShim permissionShim, ServiceDeskUserLicenseService serviceDeskUserLicenseService) {
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
        this.permissionShim = permissionShim;
        this.serviceDeskUserLicenseService = serviceDeskUserLicenseService;
    }

    @Override
    public List<ApplicationUser> getActiveUsersWithAgentLicense(int limit) {
        return this.doGetUsersWithAgentLicense(limit, true);
    }

    private List<ApplicationUser> doGetUsersWithAgentLicense(final int limit, boolean mustBeActive) {
        final boolean isLimit = limit >= 0;
        Predicate<Set<ApplicationUser>> breakFunction = new Predicate<Set<ApplicationUser>>(){

            public boolean apply(Set<ApplicationUser> input) {
                return isLimit && input.size() >= limit;
            }
        };
        HashSet users = Sets.newHashSet();
        block0: for (Group group : this.getGroupsWithAgentPermission()) {
            if (breakFunction.apply((Object)users)) break;
            for (ApplicationUser applicationUser : this.groupManager.getUsersInGroup(group)) {
                if (breakFunction.apply((Object)users)) break block0;
                if (mustBeActive && !applicationUser.isActive() || !this.hasJiraAccess(applicationUser)) continue;
                users.add(applicationUser);
            }
        }
        ArrayList sortedUsers = Lists.newArrayList((Iterable)users);
        Collections.sort(sortedUsers, USER_COMPARATOR);
        return sortedUsers;
    }

    private boolean hasJiraAccess(ApplicationUser applicationUser) {
        List usePermissionList = this.permissionShim.getUseGlobalPermissions();
        for (GlobalPermissionKey usePermission : usePermissionList) {
            if (!this.globalPermissionManager.hasPermission(usePermission, applicationUser)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public Collection<Group> getGroupsWithAgentPermission() {
        return this.serviceDeskUserLicenseService.getAgentGroups();
    }
}

