/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionOverride;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.permission.PermissionOverrideHelper;

public class ServiceDeskCollaboratorPermissionOverride
implements ProjectPermissionOverride {
    private final PermissionOverrideHelper permissionOverrideHelper;
    private static final ProjectPermissionOverride.Reason NO_VETO_MESSAGE = new ProjectPermissionOverride.Reason("sd.permission.veto.false.summary", "sd.permission.veto.false.description");
    private static final ProjectPermissionOverride.Reason VETO_MESSAGE = new ProjectPermissionOverride.Reason("sd.permission.veto.true.summary", "sd.permission.veto.true.description.app");

    public ServiceDeskCollaboratorPermissionOverride(PermissionOverrideHelper permissionOverrideHelper) {
        this.permissionOverrideHelper = permissionOverrideHelper;
    }

    public ProjectPermissionOverride.Decision hasPermission(ProjectPermissionKey projectPermissionKey, Project project, ApplicationUser applicationUser) {
        if (this.permissionOverrideHelper.shouldDenyPermission(projectPermissionKey, project, applicationUser)) {
            return ProjectPermissionOverride.Decision.DENY;
        }
        return ProjectPermissionOverride.Decision.ABSTAIN;
    }

    public ProjectPermissionOverride.Reason getReason(ProjectPermissionKey projectPermissionKey, Project project, ApplicationUser applicationUser) {
        if (this.permissionOverrideHelper.shouldDenyPermission(projectPermissionKey, project, applicationUser)) {
            return VETO_MESSAGE;
        }
        return NO_VETO_MESSAGE;
    }
}

