/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.servicedesk.internal.utils.context.PermissionOverrideContext;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionOverrideHelper {
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;
    private final CustomerContextService customerContextService;
    private final ServiceDeskManager serviceDeskManager;
    private final UserFactory userFactory;
    private final PermissionOverrideContext permissionOverrideContext;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final RequestCache<String, Boolean> permissionCache;
    private static final List<ProjectPermissionKey> IGNORED_PERMISSIONS = ImmutableList.of((Object)ProjectPermissions.ADMINISTER_PROJECTS, (Object)ProjectPermissions.BROWSE_PROJECTS, (Object)ProjectPermissions.CREATE_ISSUES, (Object)ProjectPermissions.ADD_COMMENTS, (Object)ProjectPermissions.EDIT_OWN_COMMENTS, (Object)ProjectPermissions.DELETE_OWN_COMMENTS, (Object)ProjectPermissions.CREATE_ATTACHMENTS, (Object)ProjectPermissions.DELETE_OWN_ATTACHMENTS, (Object)ProjectPermissions.VIEW_DEV_TOOLS);
    private static final String NULL_STRING = "null";

    @Autowired
    public PermissionOverrideHelper(ServiceDeskOperationalStatus serviceDeskOperationalStatus, CustomerContextService customerContextService, ServiceDeskManager serviceDeskManager, UserFactory userFactory, PermissionOverrideContext permissionOverrideContext, ServiceDeskPermissions serviceDeskPermissions, VCacheFactory vCacheFactory) {
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
        this.customerContextService = customerContextService;
        this.serviceDeskManager = serviceDeskManager;
        this.userFactory = userFactory;
        this.permissionOverrideContext = permissionOverrideContext;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.permissionCache = vCacheFactory.getRequestCache(CacheUtil.standardName(this, "collaboratorPermissionOverrideCache"));
    }

    public boolean shouldDenyPermission(ProjectPermissionKey projectPermissionKey, Project project, ApplicationUser user) {
        if (this.permissionOverrideContext.isInPermissionOverrideContext()) {
            return false;
        }
        if (!this.serviceDeskOperationalStatus.isOperational()) {
            return false;
        }
        String cacheKey = this.generateCacheKey(projectPermissionKey, project, user);
        return (Boolean)this.permissionCache.get((Object)cacheKey, () -> this.isVetoablePermission(projectPermissionKey) && this.inJIRAContext() && this.serviceDeskManager.isServiceDeskEnabled(project) && this.shouldDenyUserPermission(user, project));
    }

    private boolean shouldDenyUserPermission(ApplicationUser user, Project project) {
        return (Boolean)this.userFactory.wrap(user).fold(error -> true, validUser -> (Boolean)this.permissionOverrideContext.inPermissionOverrideContext(() -> !this.serviceDeskPermissions.canViewAgentView((SDUser)validUser, project)));
    }

    private boolean isVetoablePermission(ProjectPermissionKey projectPermissionKey) {
        return !IGNORED_PERMISSIONS.contains(projectPermissionKey);
    }

    private boolean inJIRAContext() {
        return !this.customerContextService.isInCustomerContext();
    }

    private String generateCacheKey(ProjectPermissionKey projectPermissionKey, Project project, ApplicationUser user) {
        String userCacheKey = (String)Option.option((Object)user).map(valueUser -> valueUser.getKey() + ":" + valueUser.getDirectoryId()).getOrElse((Object)NULL_STRING);
        String projectCacheKey = (String)Option.option((Object)project).map(Project::getKey).getOrElse((Object)NULL_STRING);
        return "permissionOverride_" + userCacheKey + "_" + projectCacheKey + "_" + projectPermissionKey.permissionKey();
    }
}

