/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.onboarding.data;

import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class ProjectPickerDataProvider
implements WebResourceDataProvider {
    private final UserFactory userFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final InternalServiceDeskProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ServiceDeskInternalManager serviceDeskManager;
    private static final String IT_PROJECT_KEY = "IT";
    private static final String BASIC_PROJECT_KEY = "SD";

    public ProjectPickerDataProvider(UserFactory userFactory, ServiceDeskPermissions serviceDeskPermissions, InternalServiceDeskProjectManager projectManager, JiraAuthenticationContext jiraAuthenticationContext, ServiceDeskInternalManager serviceDeskManager) {
        this.userFactory = userFactory;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.serviceDeskManager = serviceDeskManager;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    ProjectPickerDataProvider.this.getJsonData().write(writer);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private JSONObject getJsonData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        io.atlassian.fugue.Either checkedUserEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (checkedUserEither.isRight()) {
            CheckedUser user = (CheckedUser)checkedUserEither.right().get();
            boolean isAdmin = this.isAdmin(user);
            map.put("isAdmin", isAdmin);
            if (isAdmin) {
                map.put("doEnabledServiceDesksExist", this.doEnabledServiceDesksExist());
                map.put("projectCreationData", this.getProjectCreationData());
            }
        }
        return new JSONObject(map);
    }

    private boolean isAdmin(CheckedUser user) {
        return this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
    }

    private boolean doEnabledServiceDesksExist() {
        return this.serviceDeskManager.doEnabledServiceDesksExist();
    }

    private Map<String, Map<String, String>> getProjectCreationData() {
        Map<String, Map<String, String>> data = this.getDefaultProjectCreationData();
        for (Map<String, String> projectType : data.values()) {
            int nextSuffix = 2;
            String key = projectType.get("projectKey");
            String name = projectType.get("projectName");
            while (this.projectNameOrKeyExists(name, key)) {
                key = projectType.get("projectKey") + nextSuffix;
                name = projectType.get("projectName") + " " + nextSuffix;
                ++nextSuffix;
            }
            projectType.put("projectKey", key);
            projectType.put("projectName", name);
        }
        return data;
    }

    private Map<String, Map<String, String>> getDefaultProjectCreationData() {
        HashMap<String, Map<String, String>> defaults = new HashMap<String, Map<String, String>>();
        HashMap<String, String> basicMap = new HashMap<String, String>();
        basicMap.put("projectKey", BASIC_PROJECT_KEY);
        basicMap.put("projectName", this.getText("sd.renaissance.onboarding.default.project.name.basic"));
        defaults.put(BASIC_PROJECT_KEY, basicMap);
        HashMap<String, String> itMap = new HashMap<String, String>();
        itMap.put("projectKey", IT_PROJECT_KEY);
        itMap.put("projectName", this.getText("sd.renaissance.onboarding.default.project.name.itsm"));
        defaults.put(IT_PROJECT_KEY, itMap);
        return defaults;
    }

    private boolean projectNameOrKeyExists(String name, String key) {
        return this.projectManager.getProjectByName(name).isRight() || this.projectManager.getProjectByKey(key).isRight();
    }

    private String getText(String i18nKey) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(i18nKey);
    }
}

