/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.UnsubscribeLinkHelper;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.notifications.render.InternalUnsubscribeLinkHelper;
import com.atlassian.servicedesk.internal.util.tokens.UnsubscribeTokenGenerator;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={UnsubscribeLinkHelper.class})
@ParametersAreNonnullByDefault
public class UnsubscribeLinkHelperImpl
implements InternalUnsubscribeLinkHelper {
    private static Logger logger = LoggerFactory.getLogger(UnsubscribeLinkHelperImpl.class);
    private final FeatureManager featureManager;
    private final UnsubscribeTokenGenerator tokenGeneratorService;
    private final PortalInternalManager portalInternalManager;
    private final UserFactory userFactory;
    private final PortalUrlsProvider portalUrlsProvider;

    @Autowired
    public UnsubscribeLinkHelperImpl(FeatureManager featureManager, UnsubscribeTokenGenerator tokenGeneratorService, PortalInternalManager portalInternalManager, UserFactory userFactory, PortalUrlsProvider portalUrlsProvider) {
        this.featureManager = featureManager;
        this.tokenGeneratorService = tokenGeneratorService;
        this.portalInternalManager = portalInternalManager;
        this.userFactory = userFactory;
        this.portalUrlsProvider = portalUrlsProvider;
    }

    public io.atlassian.fugue.Option<String> getUnsubscribeLink(Issue issue, ApplicationUser recipient) {
        return (io.atlassian.fugue.Option)Steps.begin(this.portalInternalManager.getPortalByProject(issue.getProjectObject())).then(portal -> StepsConverters.newerEither((Either)this.userFactory.wrap(recipient))).yield((portal, checkedUser) -> this.getUnsubscribeLinkWithToken(issue, (Portal)portal, (CheckedUser)checkedUser)).getOrElse((Object)io.atlassian.fugue.Option.none());
    }

    @Override
    public io.atlassian.fugue.Option<CheckedUser> getUnsubscribedUser(@Nonnull String jwtPayload) {
        io.atlassian.fugue.Option<String> userClaim = this.findUserClaim(jwtPayload);
        return (io.atlassian.fugue.Option)userClaim.map(user -> StepsConverters.newerOption((Option)this.userFactory.wrapUserKey(user).toOption())).getOrElse((Object)io.atlassian.fugue.Option.none());
    }

    private io.atlassian.fugue.Option<String> getUnsubscribeLinkWithToken(Issue issue, Portal portal, CheckedUser recipient) {
        io.atlassian.fugue.Option<String> token = this.tokenGeneratorService.generateToken(issue, portal, recipient);
        return token.map(jwtToken -> this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).unsubscribe(issue.getKey(), jwtToken).toString());
    }

    private io.atlassian.fugue.Option<String> findUserClaim(String jwtPayload) {
        try {
            JsonObject json = new JsonParser().parse(jwtPayload).getAsJsonObject();
            if (!json.has("context")) {
                logger.warn("Cannot find context claim from jwt payload");
                return io.atlassian.fugue.Option.none();
            }
            JsonObject contextClaim = json.getAsJsonObject("context");
            if (!contextClaim.has("user")) {
                logger.warn("Cannot find user claim from jwt payload");
                return io.atlassian.fugue.Option.none();
            }
            return io.atlassian.fugue.Option.some((Object)contextClaim.get("user").getAsString());
        }
        catch (JsonSyntaxException syntaxException) {
            logger.warn("Failed to parse jsonPayload");
            return io.atlassian.fugue.Option.none();
        }
    }
}

