/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.MailImageInliner;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.notifications.FeedbackAttachmentManager;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.internal.api.notifications.render.StylingBodyFinaliser;
import com.atlassian.servicedesk.internal.api.request.CustomerTextRenderer;
import com.atlassian.servicedesk.internal.notifications.HTMLBody;
import com.atlassian.servicedesk.internal.notifications.TextBody;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.mail.BodyPart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class StylingBodyFinaliserImpl
implements StylingBodyFinaliser {
    private final MailImageInliner mailImageInliner;
    private final CustomerTextRenderer customerTextRenderer;
    private final UserFactory userFactory;
    private final FeedbackAttachmentManager feedbackAttachmentManager;

    @Autowired
    public StylingBodyFinaliserImpl(MailImageInliner mailImageInliner, CustomerTextRenderer customerTextRenderer, UserFactory userFactory, FeedbackAttachmentManager feedbackAttachmentManager) {
        this.mailImageInliner = mailImageInliner;
        this.customerTextRenderer = customerTextRenderer;
        this.userFactory = userFactory;
        this.feedbackAttachmentManager = feedbackAttachmentManager;
    }

    public io.atlassian.fugue.Either<AnError, ServiceDeskEmailBody> buildHtmlBody(ApplicationUser recipient, RenderedHtmlContent renderedHtmlContent, Option<Issue> issueOpt) {
        return StepsConverters.newerEither((Either)this.userFactory.wrap(recipient)).map(checkedUser -> this.buildMessageBodyForRecipient((CheckedUser)checkedUser, renderedHtmlContent, issueOpt)).map(messageBody -> {
            if (renderedHtmlContent.shouldAttachFeedbackStar()) {
                return this.feedbackAttachmentManager.attachStarLogo((ServiceDeskEmailBody)messageBody);
            }
            return messageBody;
        });
    }

    public io.atlassian.fugue.Either<AnError, ServiceDeskEmailBody> buildTextBody(String textContent) {
        return io.atlassian.fugue.Either.right((Object)new TextBody(textContent));
    }

    private HTMLBody buildMessageBodyForRecipient(CheckedUser checkedUser, RenderedHtmlContent renderedHtmlContent, Option<Issue> issueOpt) {
        String htmlContent = renderedHtmlContent.getHtmlContent();
        String textContent = renderedHtmlContent.getTextContent();
        return this.buildMultiPartHtmlEmailBody(checkedUser, issueOpt, htmlContent, textContent);
    }

    private HTMLBody buildMultiPartHtmlEmailBody(CheckedUser recipient, Option<Issue> issueOpt, String htmlContent, String textContent) {
        MailImageInliner.InlinedEmailBody inlinedEmailBody = this.inlineHtml(htmlContent, issueOpt);
        Option issueIdOpt = issueOpt.map(Issue::getId);
        String html = this.customerTextRenderer.updateEmailTextForCustomer(inlinedEmailBody.getHtml(), Option.some((Object)recipient), issueIdOpt);
        return new HTMLBody(html, (Option<String>)Option.some((Object)textContent), (List<BodyPart>)ImmutableList.copyOf((Iterable)inlinedEmailBody.getBodyParts()));
    }

    private MailImageInliner.InlinedEmailBody inlineHtml(String html, Option<Issue> issueOpt) {
        return (MailImageInliner.InlinedEmailBody)issueOpt.fold(() -> this.mailImageInliner.inlineImages(html), issue -> this.mailImageInliner.inlineImages(html, issue));
    }
}

