/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.analytics.ServiceDeskAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.notifications.FeedbackAttachmentManager;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationLegacyLayoutRenderer;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.internal.api.notifications.render.SDRendererUtils;
import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.notifications.NotificationMessageContextInternalUtils;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class NotificationLayoutRendererImpl
implements NotificationLegacyLayoutRenderer {
    private final String BASE_EMAIL_TEMPLATE = "ServiceDesk.Templates.Notifications.Custom.legacyEmailTemplate";
    private static final String CONTENT = "content";
    private static final String SHARED_PORTAL_LOGO_ID = "sharedPortalLogoId";
    private static final String MARKER_ENABLED = "isMarkerInsertionEnabled";
    private static final String REQUEST_URL_IN_PORTAL = "portalURL";
    private static final String ISSUE = "issue";
    private final NotificationMessageContextInternalUtils notificationMessageContextUtils;
    private final ServiceDeskManager serviceDeskManager;
    private final SDRendererUtils sdRendererUtils;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final AuthenticationContextUtil authenticationContextUtil;
    private final UserFactory userFactory;
    private final PortalInternalManager portalInternalManager;
    private final FeedbackAttachmentManager feedbackAttachmentManager;
    private final PortalUrlsProvider portalUrlsProvider;
    private final ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService;

    @Autowired
    public NotificationLayoutRendererImpl(NotificationMessageContextInternalUtils notificationMessageContextUtils, ServiceDeskManager serviceDeskManager, SDRendererUtils sdRendererUtils, HelpCenterBrandingManagerScala helpCenterBrandingManager, AuthenticationContextUtil authenticationContextUtil, UserFactory userFactory, PortalInternalManager portalInternalManager, FeedbackAttachmentManager feedbackAttachmentManager, PortalUrlsProvider portalUrlsProvider, ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService) {
        this.notificationMessageContextUtils = notificationMessageContextUtils;
        this.serviceDeskManager = serviceDeskManager;
        this.sdRendererUtils = sdRendererUtils;
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.authenticationContextUtil = authenticationContextUtil;
        this.userFactory = userFactory;
        this.portalInternalManager = portalInternalManager;
        this.feedbackAttachmentManager = feedbackAttachmentManager;
        this.portalUrlsProvider = portalUrlsProvider;
        this.serviceDeskAnalyticsSourceService = serviceDeskAnalyticsSourceService;
    }

    public io.atlassian.fugue.Either<AnError, ServiceDeskEmailBody> renderHtmlBody(ApplicationUser recipient, RenderedHtmlContent renderedHtmlContent, Project project, Option<Issue> issueOpt) {
        return StepsConverters.newerEither((Either)this.userFactory.wrap(recipient)).map(checkedUser -> this.renderAsUser(recipient, () -> this.renderHtmlBodyInternal((CheckedUser)checkedUser, renderedHtmlContent, project, issueOpt)));
    }

    public io.atlassian.fugue.Either<AnError, ServiceDeskEmailBody> renderTextBody(ApplicationUser recipient, String textContent, Project project, Option<Issue> issueOpt) {
        return StepsConverters.newerEither((Either)this.userFactory.wrap(recipient)).map(checkedUser -> {
            Callable<ServiceDeskEmailBody> callback = () -> this.renderTextBodyInternal((CheckedUser)checkedUser, textContent, project, issueOpt);
            return this.renderAsUser(recipient, callback);
        });
    }

    private Option<Portal> projectPortal(Project project) {
        return (Option)this.portalInternalManager.getPortalByProject(project).toOption().fold(Option::none, Option::some);
    }

    private ServiceDeskEmailBody renderHtmlBodyInternal(CheckedUser recipient, RenderedHtmlContent renderedHtmlContent, Project project, Option<Issue> issueOpt) {
        Option<Portal> portalOpt = this.projectPortal(project);
        Map<String, Object> commonParams = this.retrieveCommonParameters(recipient, project, portalOpt, issueOpt, "jsd-content-id-shared-portal-logo");
        Map<String, Object> htmlParams = this.formatSpecificContentParams(commonParams, renderedHtmlContent.getHtmlContent());
        Map<String, Object> textParams = this.formatSpecificContentParams(commonParams, renderedHtmlContent.getTextContent());
        ServiceDeskEmailBody serviceDeskEmailBody = this.sdRendererUtils.renderEmailBodyAsHtml(recipient, "ServiceDesk.Templates.Notifications.Custom.legacyEmailTemplate", issueOpt, htmlParams, textParams, this.sdRendererUtils.createServiceDeskDefaultApplicator());
        serviceDeskEmailBody = this.sdRendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, "jsd-content-id-shared-portal-logo");
        if (renderedHtmlContent.shouldAttachFeedbackStar()) {
            serviceDeskEmailBody = this.feedbackAttachmentManager.attachStarLogo(serviceDeskEmailBody);
        }
        return serviceDeskEmailBody;
    }

    private ServiceDeskEmailBody renderTextBodyInternal(CheckedUser recipient, String textContent, Project project, Option<Issue> issueOpt) {
        String sharedPortalLogoCid = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
        Option<Portal> portalOpt = this.projectPortal(project);
        Map<String, Object> commonParams = this.retrieveCommonParameters(recipient, project, portalOpt, issueOpt, sharedPortalLogoCid);
        Map<String, Object> textParams = this.formatSpecificContentParams(commonParams, textContent);
        return this.sdRendererUtils.renderEmailBodyAsText("ServiceDesk.Templates.Notifications.Custom.legacyEmailTemplate", textParams);
    }

    private ServiceDeskEmailBody renderAsUser(ApplicationUser user, Callable<ServiceDeskEmailBody> callback) {
        return (ServiceDeskEmailBody)this.authenticationContextUtil.runAs(user, callback);
    }

    private Map<String, Object> formatSpecificContentParams(Map<String, Object> params, String content) {
        return ImmutableMap.builder().putAll(params).put((Object)CONTENT, (Object)content).build();
    }

    private Map<String, Object> retrieveCommonParameters(CheckedUser recipient, Project project, Option<Portal> portalOpt, Option<Issue> issueOpt, String sharedPortalLogoCid) {
        ImmutableMap.Builder builder = this.sdRendererUtils.commonParameters(recipient, portalOpt);
        if (this.helpCenterBrandingManager.getHelpCenterBranding().getLogoId().isDefined()) {
            builder.put((Object)SHARED_PORTAL_LOGO_ID, (Object)sharedPortalLogoCid);
        }
        issueOpt.foreach(issue -> {
            builder.put((Object)ISSUE, issue);
            portalOpt.foreach(portal -> builder.put((Object)REQUEST_URL_IN_PORTAL, (Object)this.getPortalLinkForIssue(issue.getKey(), (Portal)portal)));
        });
        return builder.put((Object)MARKER_ENABLED, (Object)this.isMarkerInsertionEnabled(project)).build();
    }

    private boolean isMarkerInsertionEnabled(Project project) {
        return (Boolean)this.serviceDeskManager.getServiceDeskForProject(project).map(arg_0 -> ((NotificationMessageContextInternalUtils)this.notificationMessageContextUtils).isMarkerInsertionEnabledForServiceDesk(arg_0)).getOrElse((Object)false);
    }

    private String getPortalLinkForIssue(@Nonnull String issueKey, Portal portal) {
        PortalUrls portalUrls = this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE);
        try {
            String url = portalUrls.request(issueKey).toString();
            return this.serviceDeskAnalyticsSourceService.enrichURLWithSDASource(url, "notification-email");
        }
        catch (IllegalStateException e) {
            return "";
        }
    }
}

