/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.model;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.notifications.HTMLBody;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class ServiceDeskEmailImpl
implements ServiceDeskEmail {
    private static final String PLAIN_TEXT_UTF8 = "text/plain; charset=UTF-8";
    private static final String HTML_UTF8 = "text/html; charset=UTF-8";
    private final String toAddress;
    private final Option<String> fromAddressOpt;
    private final Option<String> fromNameOpt;
    private final String subject;
    private final ServiceDeskEmailBody body;
    private final Option<Project> projectOpt;
    private final Option<Issue> issueOpt;
    private final Option<String> replyToHeaderOpt;
    private final boolean includeMailServerSubjectPrefix;

    ServiceDeskEmailImpl(String toAddress, Option<String> fromAddressOpt, Option<String> fromNameOpt, String subject, ServiceDeskEmailBody body, Option<Project> projectOpt, Option<Issue> issueOpt, Option<String> replyToHeaderOpt, boolean includeMailServerSubjectPrefix) {
        this.toAddress = toAddress;
        this.fromAddressOpt = fromAddressOpt;
        this.fromNameOpt = fromNameOpt;
        this.subject = subject;
        this.body = body;
        this.projectOpt = projectOpt;
        this.issueOpt = issueOpt;
        this.replyToHeaderOpt = replyToHeaderOpt;
        this.includeMailServerSubjectPrefix = includeMailServerSubjectPrefix;
    }

    public Email buildEmail() {
        Email email = new Email(this.toAddress);
        email.setSubject(this.subject).setEncoding("UTF-8").setFrom((String)this.fromAddressOpt.getOrNull()).setFromName((String)this.fromNameOpt.getOrNull()).setReplyTo((String)this.replyToHeaderOpt.getOrNull()).setExcludeSubjectPrefix(!this.includeMailServerSubjectPrefix);
        try {
            if (this.body instanceof HTMLBody) {
                email.setMultipart((Multipart)this.getMultiPartBody(email, (HTMLBody)this.body));
            } else {
                email.setMimeType("text/plain");
                email.setBody(this.body.getBody());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return email;
    }

    public Option<Project> getProject() {
        return this.projectOpt;
    }

    public Option<Issue> getIssue() {
        return this.issueOpt;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    @VisibleForTesting
    public Option<String> getFromName() {
        return this.fromNameOpt;
    }

    @VisibleForTesting
    public String getSubject() {
        return this.subject;
    }

    @VisibleForTesting
    public ServiceDeskEmailBody getBody() {
        return this.body;
    }

    @VisibleForTesting
    public Option<String> getFromAddressOpt() {
        return this.fromAddressOpt;
    }

    @VisibleForTesting
    public Option<String> getReplyToHeaderOpt() {
        return this.replyToHeaderOpt;
    }

    private MimeMultipart getMultiPartBody(Email email, HTMLBody htmlBody) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("alternative");
        for (String text : htmlBody.getTextOpt()) {
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setContent((Object)text, PLAIN_TEXT_UTF8);
            multipart.addBodyPart((BodyPart)textPart);
        }
        multipart.addBodyPart((BodyPart)this.getHTMLBodyPart(htmlBody));
        return multipart;
    }

    private MimeBodyPart getHTMLBodyPart(HTMLBody htmlBody) throws MessagingException {
        MimeBodyPart result = new MimeBodyPart();
        result.setContent((Object)htmlBody.getBody(), HTML_UTF8);
        if (!htmlBody.getBodyParts().isEmpty()) {
            MimeMultipart relatedPart = new MimeMultipart("related");
            MimeBodyPart htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Object)htmlBody.getBody(), HTML_UTF8);
            relatedPart.addBodyPart((BodyPart)htmlBodyPart);
            for (BodyPart bodyPart : htmlBody.getBodyParts()) {
                relatedPart.addBodyPart(bodyPart);
            }
            result.setContent((Multipart)relatedPart);
        }
        return result;
    }
}

