/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.approvals;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.ApprovalRequestEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.SDEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.api.notifications.approvals.ApprovalsNotificationSenderService;
import com.atlassian.servicedesk.internal.api.notifications.approvals.RequestToApproveNotificationsData;
import com.atlassian.servicedesk.internal.api.notifications.approvals.RequestToApproveNotificationsDataBuilder;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.notifications.approvals.ApprovalsNotificationRenderer;
import com.atlassian.servicedesk.internal.notifications.approvals.RequestToApproveNotificationDataBuilderImpl;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ApprovalsNotificationSenderServiceImpl
implements ApprovalsNotificationSenderService {
    private static Logger logger = LoggerFactory.getLogger(ApprovalsNotificationSenderServiceImpl.class);
    private final ServiceDeskNotificationInternalSender notificationSender;
    private final ApprovalsNotificationRenderer approvalsNotificationRenderer;
    private final UserFactory userFactory;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final AnalyticsService analyticsService;

    @Autowired
    public ApprovalsNotificationSenderServiceImpl(ServiceDeskNotificationInternalSender notificationSender, ApprovalsNotificationRenderer approvalsNotificationRenderer, UserFactory userFactory, ServiceDeskInternalManager serviceDeskManager, AnalyticsService analyticsService) {
        this.notificationSender = notificationSender;
        this.approvalsNotificationRenderer = approvalsNotificationRenderer;
        this.userFactory = userFactory;
        this.serviceDeskManager = serviceDeskManager;
        this.analyticsService = analyticsService;
    }

    public RequestToApproveNotificationsDataBuilder requestToApproveDataBuilder() {
        return new RequestToApproveNotificationDataBuilderImpl();
    }

    public boolean isApprovalNotificationEnabledForProject(@Nonnull Project project) {
        return this.notificationSender.isOutgoingMailConfigured() && this.notificationSender.isServiceDeskNotificationEnabled();
    }

    public Collection<ApplicationUser> sendRequestToApproveNotifications(RequestToApproveNotificationsData notificationsData) {
        if (!this.isApprovalNotificationEnabledForIssue(notificationsData.getIssue())) {
            logger.debug("Approval Notification is not enabled, no approval notification will be sent for issue=" + notificationsData.getIssue().getKey());
            return Lists.newArrayList();
        }
        if (!this.isValidNotificationData(notificationsData)) {
            logger.debug("Invalid notification data, no approval notification will be sent for issue=" + notificationsData.getIssue().getKey());
            return Lists.newArrayList();
        }
        Collection<ApplicationUser> receivedUser = this.sendNotifications(notificationsData);
        return receivedUser;
    }

    private boolean isApprovalNotificationEnabledForIssue(Issue issue) {
        return (Boolean)Option.option((Object)issue.getProjectObject()).map(this::isApprovalNotificationEnabledForProject).getOrElse((Object)false);
    }

    private boolean isValidNotificationData(RequestToApproveNotificationsData notificationsData) {
        Issue issue = notificationsData.getIssue();
        Option validServiceDesk = this.serviceDeskManager.getServiceDesk(issue.getProjectObject(), false).toOption();
        if (validServiceDesk.isEmpty()) {
            logger.warn("No valid Service Desk found for issue=" + issue.getKey());
            return false;
        }
        return true;
    }

    private Collection<ApplicationUser> sendNotifications(RequestToApproveNotificationsData notificationsData) {
        Collection<ApplicationUser> validApproversRecipients = this.getValidRecipient(notificationsData);
        Collection<CheckedUser> checkedUsers = this.convertToCheckedUsers(validApproversRecipients);
        this.notificationSender.enqueueDeferredNotificationTask(null, () -> {
            ApprovalRequestEmailSendEvent emailAnalyticsEvent = new ApprovalRequestEmailSendEvent();
            Collection<ServiceDeskEmail> serviceDeskEmails = this.approvalsNotificationRenderer.createApprovalNotification(checkedUsers, notificationsData.getIssue(), (SDEmailAnalyticsEvent)emailAnalyticsEvent);
            for (ServiceDeskEmail email : serviceDeskEmails) {
                this.notificationSender.send(email);
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
            }
        });
        return validApproversRecipients;
    }

    private Collection<ApplicationUser> getValidRecipient(RequestToApproveNotificationsData notificationsData) {
        return notificationsData.getApprovers();
    }

    private Collection<CheckedUser> convertToCheckedUsers(Collection<ApplicationUser> applicationUsers) {
        return this.convertToCheckedUser(applicationUsers);
    }

    private Collection<CheckedUser> convertToCheckedUser(Collection<ApplicationUser> approvers) {
        return approvers.stream().map(approver -> StepsConverters.newerEither((Either)this.userFactory.wrap(approver))).filter(io.atlassian.fugue.Either::isRight).map(checkedUserEither -> (CheckedUser)checkedUserEither.right().get()).collect(Collectors.toList());
    }
}

