/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.approvals;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.SDEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBuilderFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.SDRendererUtils;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.issue.IssueUrlProvider;
import com.atlassian.servicedesk.internal.notifications.NotificationMessageContextInternalUtils;
import com.atlassian.servicedesk.internal.notifications.approvals.ApprovalsNotificationRenderer;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsNotificationRendererImpl
implements ApprovalsNotificationRenderer {
    private final I18nHelper i18nHelper;
    private final SDRendererUtils rendererUtils;
    private final UserFactory userFactory;
    private final PortalInternalManager internalPortalManager;
    private final NotificationMessageContextInternalUtils notificationMessageContextUtils;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final VpOriginManager vpOriginManager;
    private final IssueUrlProvider issueUrlProvider;
    private final ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory;
    private final String ISSUE_URL = "issueUrl";
    private final String PORTAL_ID = "portalId";
    private final String ISSUE_KEY = "issueKey";
    private final String ISSUE = "issue";
    private final String SHARED_PORTAL_LOGO_ID = "sharedPortalLogoId";
    private static final String EMAIL_TRACKING_EVENT_NAME = "emailTrackingEventName";

    @Autowired
    public ApprovalsNotificationRendererImpl(I18nHelper i18nHelper, SDRendererUtils rendererUtils, UserFactory userFactory, PortalInternalManager internalPortalManager, NotificationMessageContextInternalUtils notificationMessageContextUtils, HelpCenterBrandingManagerScala helpCenterBrandingManager, VpOriginManager vpOriginManager, IssueUrlProvider issueUrlProvider, ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory) {
        this.i18nHelper = i18nHelper;
        this.rendererUtils = rendererUtils;
        this.userFactory = userFactory;
        this.internalPortalManager = internalPortalManager;
        this.notificationMessageContextUtils = notificationMessageContextUtils;
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.vpOriginManager = vpOriginManager;
        this.issueUrlProvider = issueUrlProvider;
        this.serviceDeskEmailBuilderFactory = serviceDeskEmailBuilderFactory;
    }

    @Override
    public Collection<ServiceDeskEmail> createApprovalNotification(Collection<CheckedUser> approvers, Issue issue, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        String subject = this.createApprovalNotificationSubject(issue);
        Project project = issue.getProjectObject();
        String fromAddress = project.getEmail();
        String fromName = project.getName();
        Collection result = approvers.stream().flatMap(approver -> this.buildServiceDeskEmail((CheckedUser)approver, subject, fromAddress, fromName, issue, emailAnalyticsEvent)).collect(Collectors.toList());
        return result;
    }

    private String createApprovalNotificationSubject(Issue issue) {
        return this.i18nHelper.getText("sd.email.approvals.notification.request.to.approve.subject", issue.getKey(), issue.getSummary());
    }

    private Collection<CheckedUser> convertToCheckedUser(Collection<ApplicationUser> approvers) {
        return approvers.stream().map(approver -> StepsConverters.newerEither((Either)this.userFactory.wrap(approver))).filter(io.atlassian.fugue.Either::isRight).map(checkedUserEither -> (CheckedUser)checkedUserEither.right().get()).collect(Collectors.toList());
    }

    private Stream<ServiceDeskEmail> buildServiceDeskEmail(CheckedUser approver, String subject, String fromAddress, String fromName, Issue issue, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        ServiceDeskEmailBody body = this.buildRequestToApproveEmailBody(approver, issue, emailAnalyticsEvent);
        ServiceDeskEmail.Builder builder = this.serviceDeskEmailBuilderFactory.newBuilder();
        ServiceDeskEmail email = builder.toAddress(approver.getEmailAddress()).subject(subject).serviceDeskEmailBody(body).fromAddress(fromAddress).fromName(fromName).issue(issue).build();
        return Stream.of(email);
    }

    private ServiceDeskEmailBody buildRequestToApproveEmailBody(CheckedUser approver, Issue issue, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
        Map<String, Object> contentParams = this.createTemplateParams(approver, issue, logoId, emailAnalyticsEvent);
        ServiceDeskEmailBody body = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(approver, "ServiceDesk.Templates.Notifications.Approvals.requestToApprove", Option.some((Object)issue), contentParams);
        return this.rendererUtils.attachHelpCenterLogo(body, logoId);
    }

    private Map<String, Object> createTemplateParams(CheckedUser approver, Issue issue, String logoId, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        ImmutableMap.Builder contentParams = this.rendererUtils.commonParameters(approver, Option.none());
        Portal portal = (Portal)this.internalPortalManager.getPortalByProject(issue.getProjectObject()).right().get();
        String issueUrl = this.getUrlForIssue(portal, issue);
        Option<Integer> logoIdOpt = this.helpCenterBrandingManager.getHelpCenterBranding().getLogoId();
        if (logoIdOpt.isDefined()) {
            contentParams.put((Object)"sharedPortalLogoId", (Object)logoId);
        }
        contentParams.put((Object)"portalId", (Object)portal.getId());
        contentParams.put((Object)"issueKey", (Object)issue.getKey());
        contentParams.put((Object)"issueUrl", (Object)issueUrl);
        contentParams.put((Object)"issue", (Object)issue);
        contentParams.put((Object)EMAIL_TRACKING_EVENT_NAME, (Object)emailAnalyticsEvent.getEmailKey());
        return contentParams.build();
    }

    private String getUrlForIssue(Portal portal, Issue issue) {
        if (this.vpOriginManager.lookup(issue) == null) {
            return this.issueUrlProvider.getIssueURI(issue, ProjectUrlsProvider.UrlMode.ABSOLUTE).toString();
        }
        return this.notificationMessageContextUtils.getPortalIssueUrl(portal, issue);
    }
}

