/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.botocss.Botocss;
import com.atlassian.servicedesk.internal.utils.DevMode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskEmailCssLoader {
    private static final Resource STYLESHEET = new ClassPathResource("/css/usernotifications/sd-notifications.css");
    private final String css = this.loadCss(STYLESHEET);

    public String applyStyles(String html) {
        return Botocss.inject((String)html, (String[])new String[]{this.useCss()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadCss(Resource resource) {
        try (InputStream stream = resource.getInputStream();){
            String string = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String useCss() {
        if (DevMode.isOn()) {
            return this.loadCss(STYLESHEET);
        }
        return this.css;
    }
}

