/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientConfiguration;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientResolutionManager;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientType;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionService;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RecipientResolutionManagerImpl
implements RecipientResolutionManager {
    @VisibleForTesting
    final Map<RecipientType, Function<Issue, Set<CheckedUser>>> recipientResolvers = ImmutableMap.builder().put((Object)RecipientType.REQUEST_REPORTER, this::resolveRequestReporter).put((Object)RecipientType.REQUEST_PARTICIPANTS, this::resolveParticipants).put((Object)RecipientType.ALL_CUSTOMERS_INVOLVED, this::resolveAllCustomersInvolved).build();
    private final NotificationSubscriptionService notificationSubscriptionService;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final CustomerInvolvedService customerInvolvedService;

    @Autowired
    public RecipientResolutionManagerImpl(NotificationSubscriptionService notificationSubscriptionService, VpOriginCustomFieldService vpOriginCustomFieldService, CustomerInvolvedService customerInvolvedService) {
        this.notificationSubscriptionService = notificationSubscriptionService;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.customerInvolvedService = customerInvolvedService;
    }

    public Either<AnError, Set<CheckedUser>> resolveRecipients(@Nonnull Issue issue, @Nonnull RecipientConfiguration recipientConfiguration) {
        if (!this.isRequest(issue)) {
            return Either.right(Collections.emptySet());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        recipientConfiguration.getRecipientsRespectingSubscription().forEach(recipientType -> builder.addAll(this.resolveRecipients((RecipientType)recipientType, issue)));
        recipientConfiguration.getRecipientsIgnoringSubscription().forEach(recipientType -> builder.addAll(this.resolveRecipientsIgnoringSubscriptionSetting((RecipientType)recipientType, issue)));
        Set<CheckedUser> result = this.applyExclusions((Set<CheckedUser>)builder.build(), recipientConfiguration);
        return Either.right(result);
    }

    private boolean isRequest(Issue issue) {
        CustomField customField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        return issue.getCustomFieldValue(customField) != null;
    }

    private Set<CheckedUser> resolveRecipients(RecipientType recipientType, Issue issue) {
        Set<CheckedUser> recipients = this.resolveRecipientsIgnoringSubscriptionSetting(recipientType, issue);
        return recipients.stream().filter(recipient -> (Boolean)this.notificationSubscriptionService.isSubscribed((CheckedUser)recipient, issue).getOrElse((Object)false)).collect(Collectors.toSet());
    }

    private Set<CheckedUser> resolveRecipientsIgnoringSubscriptionSetting(RecipientType recipientType, Issue issue) {
        return this.recipientResolvers.get(recipientType).apply(issue);
    }

    private Set<CheckedUser> applyExclusions(Set<CheckedUser> unfilteredUsers, RecipientConfiguration recipientConfiguration) {
        Predicate<CheckedUser> excludeUserFilter = user -> (Boolean)recipientConfiguration.getExcludedUser().fold(() -> true, excludedUser -> !excludedUser.equals(user));
        return unfilteredUsers.stream().filter(excludeUserFilter).collect(Collectors.toSet());
    }

    private Set<CheckedUser> resolveRequestReporter(Issue issue) {
        return ImmutableSet.copyOf((Collection)this.customerInvolvedService.getMembersForTypes(issue, new CustomerInvolvedType[]{CustomerInvolvedType.REPORTER}));
    }

    private Set<CheckedUser> resolveParticipants(Issue issue) {
        return ImmutableSet.copyOf((Collection)this.customerInvolvedService.getMembersForTypes(issue, new CustomerInvolvedType[]{CustomerInvolvedType.REQUEST_PARTICIPANT}));
    }

    private Set<CheckedUser> resolveAllCustomersInvolved(Issue issue) {
        return ImmutableSet.copyOf((Collection)this.customerInvolvedService.getMembers(issue));
    }
}

