/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationMessageContextUtils;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.channel.IssueChannelService;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailPlatformChannelManager;
import com.atlassian.servicedesk.internal.notifications.NotificationMessageContextInternalUtils;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={NotificationMessageContextUtils.class})
class NotificationMessageContextInternalUtilsImpl
implements NotificationMessageContextInternalUtils {
    private EmailPlatformChannelManager emailPlatformChannelManager;
    private IssueChannelService issueChannelService;
    private PortalUrlsProvider portalUrlsProvider;

    @Autowired
    NotificationMessageContextInternalUtilsImpl(EmailPlatformChannelManager emailPlatformChannelManager, IssueChannelService issueChannelService, PortalUrlsProvider portalUrlsProvider) {
        this.portalUrlsProvider = portalUrlsProvider;
        this.emailPlatformChannelManager = emailPlatformChannelManager;
        this.issueChannelService = issueChannelService;
    }

    public Option<String> getReplyToHeader(CheckedUser user, Issue issue, ServiceDesk serviceDesk) {
        Option<String> emailAddressOpt = this.issueChannelService.getEmailChannelAddress((SDUser)user, issue.getId());
        return this.emailPlatformChannelManager.getEmailAddressForOutgoingNotificationReplyToHeader(serviceDesk, emailAddressOpt);
    }

    public boolean isMarkerInsertionEnabledForServiceDesk(ServiceDesk serviceDesk) {
        return !this.emailPlatformChannelManager.getValidEmailChannelsByServiceDesk(serviceDesk).isEmpty();
    }

    @Override
    public Option<String> getFromAddress(Issue issue) {
        return Option.option((Object)issue.getProjectObject()).map(Project::getEmail);
    }

    @Override
    public String getPortalIssueUrl(Portal portal, Issue issue) {
        return this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).request(issue.getKey()).toString();
    }
}

