/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.IssueCommentedEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.IssueCreatedEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.IssueReOpenedEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.IssueResolvedEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.ParticipantChangedEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.SDEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.NewlyAddedParticipantsHelper;
import com.atlassian.servicedesk.internal.api.notifications.CommentNotificationUtils;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.ServiceDeskNotificationHelper;
import com.atlassian.servicedesk.internal.notifications.IssueConversationalNotificationManager;
import com.atlassian.servicedesk.internal.notifications.IssueConversationalNotificationRenderer;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import io.atlassian.fugue.Option;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class IssueConversationalNotificationManagerImpl
implements IssueConversationalNotificationManager {
    private final IssueConversationalNotificationRenderer issueConversationalNotificationRenderer;
    private final CommentNotificationUtils commentNotificationUtils;
    private final ServiceDeskNotificationInternalSender serviceDeskNotificationSender;
    private final AnalyticsService analyticsService;
    private final InternalPortalService internalPortalService;
    private final NewlyAddedParticipantsHelper newlyAddedParticipantHelper;
    private final ServiceDeskNotificationHelper notificationHelper;
    private final CustomerInvolvedService customerInvolvedService;

    @Autowired
    public IssueConversationalNotificationManagerImpl(IssueConversationalNotificationRenderer issueConversationalNotificationRenderer, CommentNotificationUtils commentNotificationUtils, ServiceDeskNotificationInternalSender serviceDeskNotificationSender, AnalyticsService analyticsService, InternalPortalService internalPortalService, NewlyAddedParticipantsHelper newlyAddedParticipantHelper, ServiceDeskNotificationHelper notificationHelper, CustomerInvolvedService customerInvolvedService) {
        this.issueConversationalNotificationRenderer = issueConversationalNotificationRenderer;
        this.commentNotificationUtils = commentNotificationUtils;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.analyticsService = analyticsService;
        this.internalPortalService = internalPortalService;
        this.newlyAddedParticipantHelper = newlyAddedParticipantHelper;
        this.notificationHelper = notificationHelper;
        this.customerInvolvedService = customerInvolvedService;
    }

    @Override
    public void sendEmailForIssueCreated(CheckedUser sender, Issue issue, Portal portal, ServiceDesk serviceDesk) {
        this.customerInvolvedService.getMembersForTypes(issue, new CustomerInvolvedType[]{CustomerInvolvedType.REPORTER}).stream().forEach(reporter -> {
            if (this.notificationHelper.canSendNotification(issue)) {
                Runnable buildAndSendCallback = () -> {
                    IssueCreatedEmailSendEvent emailAnalyticsEvent = new IssueCreatedEmailSendEvent();
                    Option<ServiceDeskEmail> serviceDeskEmailOption = this.issueConversationalNotificationRenderer.createIssueCreatedNotification((CheckedUser)reporter, sender.getDisplayName(), issue, portal, serviceDesk, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
                    this.sendNotification(serviceDeskEmailOption);
                    this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
                };
                this.serviceDeskNotificationSender.enqueueDeferredNotificationTask(sender, buildAndSendCallback);
            }
        });
    }

    @Override
    public void sendEmailForIssueCommented(CheckedUser checkedUser, Issue issue, Comment comment, Portal portal, ServiceDesk serviceDesk) {
        Runnable buildAndSendCallback = () -> {
            List<CheckedUser> recipients = this.notificationHelper.getSubscribedNotificationRecipientsExcludingSender(issue, checkedUser);
            for (CheckedUser recipient : recipients) {
                if (!this.notificationHelper.canUserViewComment(recipient, comment)) continue;
                if (this.commentNotificationUtils.isUserNotInEmailListOfCreatedComment(recipient, comment)) {
                    IssueCommentedEmailSendEvent emailAnalyticsEvent = new IssueCommentedEmailSendEvent();
                    Option<ServiceDeskEmail> serviceDeskEmailOption = this.issueConversationalNotificationRenderer.createIssueCommentedNotification(recipient, checkedUser.getDisplayName(), issue, comment, portal, serviceDesk, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
                    this.sendNotification(serviceDeskEmailOption);
                    this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
                    continue;
                }
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new NotificationReducedEvent(this.internalPortalService.toPortalInternal(portal).getProjectId()));
            }
        };
        this.serviceDeskNotificationSender.enqueueDeferredNotificationTask(checkedUser, buildAndSendCallback);
    }

    @Override
    public void sendEmailForIssueResolved(CheckedUser sender, Issue issue, Portal portal, ServiceDesk serviceDesk, Option<Comment> commentOpt) {
        Runnable buildAndSendCallback = () -> {
            List<CheckedUser> recipients = this.notificationHelper.getSubscribedNotificationRecipientsExcludingSenderAlwaysIncludingReporter(issue, sender);
            for (CheckedUser recipient : recipients) {
                IssueResolvedEmailSendEvent emailAnalyticsEvent = new IssueResolvedEmailSendEvent();
                Option<ServiceDeskEmail> serviceDeskEmailOption = this.issueConversationalNotificationRenderer.createIssueResolvedNotification(recipient, sender.getDisplayName(), issue, portal, serviceDesk, commentOpt, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
                this.sendNotification(serviceDeskEmailOption);
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
            }
        };
        this.serviceDeskNotificationSender.enqueueDeferredNotificationTask(sender, buildAndSendCallback);
    }

    @Override
    public void sendEmailForParticipantChange(CheckedUser checkedUser, boolean isCreatedEvent, Issue issue, Collection<ChangeItemBean> changeItemBeans, Portal portal, ServiceDesk serviceDesk) {
        Runnable buildAndSendCallback = () -> {
            List participants = this.newlyAddedParticipantHelper.getNewParticipants(isCreatedEvent, issue, changeItemBeans);
            for (CheckedUser participant : participants) {
                if (!this.notificationHelper.doSDNotificationSendingRulesApply(participant, issue)) continue;
                ParticipantChangedEmailSendEvent emailAnalyticsEvent = new ParticipantChangedEmailSendEvent();
                Option<ServiceDeskEmail> serviceDeskEmailOption = this.issueConversationalNotificationRenderer.createParticipantAddedNotification(participant, checkedUser.getDisplayName(), issue, portal, serviceDesk, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
                this.sendNotification(serviceDeskEmailOption);
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
            }
        };
        this.serviceDeskNotificationSender.enqueueDeferredNotificationTask(checkedUser, buildAndSendCallback);
    }

    @Override
    public void sendEmailForIssueReOpened(CheckedUser checkedUser, Issue issue, Portal portal, ServiceDesk serviceDesk, Option<Comment> commentOpt) {
        Runnable buildAndSendCallback = () -> {
            List<CheckedUser> recipients = this.notificationHelper.getSubscribedNotificationRecipientsExcludingSender(issue, checkedUser);
            for (CheckedUser potentialRecipient : recipients) {
                IssueReOpenedEmailSendEvent emailAnalyticsEvent = new IssueReOpenedEmailSendEvent();
                Option<ServiceDeskEmail> serviceDeskEmailOption = this.issueConversationalNotificationRenderer.createIssueReOpenedNotification(potentialRecipient, checkedUser.getDisplayName(), issue, portal, serviceDesk, commentOpt, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
                this.sendNotification(serviceDeskEmailOption);
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
            }
        };
        this.serviceDeskNotificationSender.enqueueDeferredNotificationTask(checkedUser, buildAndSendCallback);
    }

    private void sendNotification(Option<ServiceDeskEmail> serviceDeskEmailOption) {
        if (serviceDeskEmailOption.isDefined()) {
            this.serviceDeskNotificationSender.send((ServiceDeskEmail)serviceDeskEmailOption.get());
        }
    }

    @EventName(value="servicedesk.action.notification.reduced")
    private static class NotificationReducedEvent
    extends AnalyticsEvent
    implements Serializable {
        private Long projectId;

        public Long getProjectId() {
            return this.projectId;
        }

        public void setProjectId(Long projectId) {
            this.projectId = projectId;
        }

        NotificationReducedEvent(Long projectId) {
            this.setProjectId(projectId);
        }
    }
}

