/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.analytics.ServiceDeskAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.SDEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBuilderFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.SDRendererUtils;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.notifications.CustomerConversationalNotificationRenderer;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerConversationalNotificationRendererImpl
implements CustomerConversationalNotificationRenderer {
    private final SDRendererUtils rendererUtils;
    private final I18nHelper i18nHelper;
    private final PortalInternalManager portalManager;
    private final CustomerUrlUtil customerUrlUtil;
    private final InternalServiceDeskProjectManager serviceDeskProjectManager;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService;
    private final ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory;
    private final AuthenticationContextUtil authenticationContextUtil;
    private static final String AGENT = "agent";
    private static final String INVITATION_LINK = "invitationLink";
    private static final String PORTAL_NAME = "portalName";
    private static final String PORTAL_URL = "portalUrl";
    private static final String CUSTOMER = "customer";
    private static final String TOKEN = "token";
    private static final String LINK = "link";
    private static final String USERNAME = "username";
    private static final String RESET_PASSWORD_PATH = "user/resetpassword";
    private static final String SHARED_PORTAL_LOGO_ID = "sharedPortalLogoId";
    private static final String EMAIL_TRACKING_EVENT_NAME = "emailTrackingEventName";

    @Autowired
    public CustomerConversationalNotificationRendererImpl(SDRendererUtils rendererUtils, I18nHelper i18nHelper, PortalInternalManager portalManager, CustomerUrlUtil customerUrlUtil, InternalServiceDeskProjectManager serviceDeskProjectManager, HelpCenterBrandingManagerScala helpCenterBrandingManager, ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService, ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory, AuthenticationContextUtil authenticationContextUtil) {
        this.rendererUtils = rendererUtils;
        this.i18nHelper = i18nHelper;
        this.portalManager = portalManager;
        this.customerUrlUtil = customerUrlUtil;
        this.serviceDeskProjectManager = serviceDeskProjectManager;
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.serviceDeskAnalyticsSourceService = serviceDeskAnalyticsSourceService;
        this.serviceDeskEmailBuilderFactory = serviceDeskEmailBuilderFactory;
        this.authenticationContextUtil = authenticationContextUtil;
    }

    @Override
    public Option<ServiceDeskEmail> createCustomerSignUpNotification(CheckedUser user, Option<Portal> portal, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        Callable<Option> renderEmail = () -> {
            String subject = this.createCustomerSignupSubject();
            String portalName = this.getPortalNameOrDefault(portal);
            String portalUrl = this.rendererUtils.getClientUrl() + "/servicedesk/customer/" + (String)portal.fold(Suppliers.ofInstance((Object)"portals"), p -> "portal/" + p.getId());
            String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
            ImmutableMap.Builder<String, Object> contentParams = this.includeCustomerCommonParams(user, portalName, logoId, emailAnalyticsEvent);
            contentParams.put((Object)CUSTOMER, (Object)user);
            contentParams.put((Object)PORTAL_URL, (Object)this.serviceDeskAnalyticsSourceService.enrichURLWithSDASource(portalUrl, "notification-email"));
            ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(user, "ServiceDesk.Templates.Conversational.Customer.signupSuccess", Option.none(), (Map)contentParams.build());
            serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
            return this.buildServiceDeskEmail(user, subject, serviceDeskEmailBody, portalName, (Option<String>)Option.none(), this.getProject(portal));
        };
        return (Option)this.authenticationContextUtil.runAs(user.forJIRA(), renderEmail);
    }

    @Override
    public Option<ServiceDeskEmail> createResetPasswordNotification(CheckedUser checkedUser, Option<Portal> portalOption, UserUtil.PasswordResetToken passwordResetToken, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return (Option)this.authenticationContextUtil.runAs(checkedUser.forJIRA(), this.createResetPasswordEmail(checkedUser, portalOption, passwordResetToken, emailAnalyticsEvent));
    }

    @Override
    public Option<ServiceDeskEmail> createAgentInviteCustomerNotification(CheckedUser agent, CheckedUser customer, Project project, String invitationLink, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        Callable<Option> renderEmail = () -> {
            Option<Portal> portal = this.getPortalByProject(project);
            String portalName = this.getPortalName(portal, project);
            String subject = this.createAgentInviteCustomerSubject(portalName);
            String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
            ImmutableMap.Builder<String, Object> contentParams = this.includeCustomerCommonParams(customer, portalName, logoId, emailAnalyticsEvent);
            contentParams.put((Object)AGENT, (Object)agent);
            contentParams.put((Object)INVITATION_LINK, (Object)this.serviceDeskAnalyticsSourceService.enrichURLWithSDASource(invitationLink, "notification-email"));
            ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(customer, "ServiceDesk.Templates.Conversational.Customer.agentInviteCustomer", Option.none(), (Map)contentParams.build());
            serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
            return this.buildServiceDeskEmail(customer, subject, serviceDeskEmailBody, portalName, (Option<String>)Option.none(), (Option<Project>)Option.some((Object)project));
        };
        return (Option)this.authenticationContextUtil.runAs(customer.forJIRA(), renderEmail);
    }

    @Override
    public Option<ServiceDeskEmail> createCustomerInvitationViaEmailChannelNotification(CheckedUser customer, Project project, String invitationLink, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        Callable<Option> renderEmail = () -> {
            Option<Portal> portal = this.getPortalByProject(project);
            String portalName = this.getPortalName(portal, project);
            String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
            ImmutableMap.Builder<String, Object> contentParams = this.includeCustomerCommonParams(customer, portalName, logoId, emailAnalyticsEvent);
            contentParams.put((Object)INVITATION_LINK, (Object)invitationLink);
            String subject = this.i18nHelper.getText("sd.email.conversational.notification.activate.your.account");
            String inviteTemplate = "ServiceDesk.Templates.Conversational.Customer.invitationViaEmailChannel";
            ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(customer, inviteTemplate, Option.none(), (Map)contentParams.build());
            serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
            return this.buildServiceDeskEmail(customer, subject, serviceDeskEmailBody, portalName, (Option<String>)Option.none(), (Option<Project>)Option.some((Object)project));
        };
        return (Option)this.authenticationContextUtil.runAs(customer.forJIRA(), renderEmail);
    }

    @Override
    public Option<ServiceDeskEmail> createCannotResetPasswordNotification(CheckedUser checkedUser, Option<Portal> portalOption, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        Callable<Option> renderEmail = () -> {
            String portalName = this.getPortalNameOrDefault(portalOption);
            Option<Project> project = this.getProject(portalOption);
            String subject = this.createPasswordResetSubject();
            String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
            ImmutableMap.Builder<String, Object> contentParams = this.includeCustomerCommonParams(checkedUser, portalName, logoId, emailAnalyticsEvent);
            ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(checkedUser, "ServiceDesk.Templates.Conversational.Customer.cannotResetPassword", Option.none(), (Map)contentParams.build());
            serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
            return this.buildServiceDeskEmail(checkedUser, subject, serviceDeskEmailBody, portalName, this.getFromAddress(project), project);
        };
        return (Option)this.authenticationContextUtil.runAs(checkedUser.forJIRA(), renderEmail);
    }

    private String createAgentInviteCustomerSubject(String portalName) {
        return this.i18nHelper.getText("sd.email.conversational.notification.agent.invite.customer.subject", portalName);
    }

    private String createCustomerSignupSubject() {
        return this.i18nHelper.getText("sd.email.conversational.notification.signup.success.subject");
    }

    private String createPasswordResetSubject() {
        return this.i18nHelper.getText("sd.email.conversational.notification.reset.password.subject");
    }

    private ImmutableMap.Builder<String, Object> includeCustomerCommonParams(CheckedUser user, String portalName, String logoId, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        ImmutableMap.Builder params = this.rendererUtils.commonParameters(user, Option.none()).put((Object)PORTAL_NAME, (Object)portalName);
        Option<Integer> logoIdOpt = this.helpCenterBrandingManager.getHelpCenterBranding().getLogoId();
        if (logoIdOpt.isDefined()) {
            params.put((Object)SHARED_PORTAL_LOGO_ID, (Object)logoId);
        }
        params.put((Object)EMAIL_TRACKING_EVENT_NAME, (Object)emailAnalyticsEvent.getEmailKey());
        return params;
    }

    private Option<Portal> getPortalByProject(Project project) {
        Either portalByProject = this.portalManager.getPortalByProject(project).map(p -> p);
        return portalByProject.right().toOption();
    }

    private String getPortalName(Option<Portal> portal, Project project) {
        if (portal.isDefined()) {
            return ((Portal)portal.get()).getName();
        }
        return project.getName();
    }

    private Option<Project> getProject(Option<Portal> portalOption) {
        if (portalOption.isDefined()) {
            return this.serviceDeskProjectManager.getProject(Long.valueOf(this.portalManager.toPortalInternal((Portal)portalOption.get()).getProjectId())).right().toOption();
        }
        return Option.none();
    }

    private Option<String> getFromAddress(Option<Project> projectOption) {
        if (projectOption.isDefined()) {
            return Option.option((Object)((Project)projectOption.get()).getEmail());
        }
        return Option.none();
    }

    private String getCustomerUrl(Option<Portal> portalOption, Map<String, String> queryParams) {
        if (portalOption.isDefined()) {
            return this.customerUrlUtil.getPortalUrl((Portal)portalOption.get(), RESET_PASSWORD_PATH, queryParams, false);
        }
        return this.customerUrlUtil.getUrl(RESET_PASSWORD_PATH, queryParams, false);
    }

    private String getPortalNameOrDefault(Option<Portal> portalOption) {
        if (portalOption.isDefined()) {
            return ((Portal)portalOption.get()).getName();
        }
        return this.helpCenterBrandingManager.getSharedPortalName();
    }

    private Callable<Option<ServiceDeskEmail>> createResetPasswordEmail(CheckedUser checkedUser, Option<Portal> portalOption, UserUtil.PasswordResetToken passwordResetToken, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return () -> {
            ImmutableMap queryParams = ImmutableMap.builder().put((Object)USERNAME, (Object)checkedUser.getName()).put((Object)TOKEN, (Object)passwordResetToken.getToken()).build();
            String customerUrl = this.getCustomerUrl(portalOption, (Map<String, String>)queryParams);
            String portalName = this.getPortalNameOrDefault(portalOption);
            String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
            ImmutableMap.Builder<String, Object> contentParams = this.includeCustomerCommonParams(checkedUser, portalName, logoId, emailAnalyticsEvent);
            contentParams.put((Object)TOKEN, (Object)passwordResetToken);
            contentParams.put((Object)LINK, (Object)customerUrl);
            ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(checkedUser, "ServiceDesk.Templates.Conversational.Customer.resetPassword", Option.none(), (Map)contentParams.build());
            serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
            Option<Project> project = this.getProject(portalOption);
            String subject = this.createPasswordResetSubject();
            return this.buildServiceDeskEmail(checkedUser, subject, serviceDeskEmailBody, portalName, this.getFromAddress(project), project);
        };
    }

    private Option<ServiceDeskEmail> buildServiceDeskEmail(CheckedUser recipient, String subject, ServiceDeskEmailBody serviceDeskEmailBody, String fromName, Option<String> fromAddress, Option<Project> project) {
        ServiceDeskEmail.Builder builder = this.serviceDeskEmailBuilderFactory.newBuilder();
        builder.toAddress(recipient.getEmailAddress()).subject(subject).serviceDeskEmailBody(serviceDeskEmailBody).projectContext(project).fromName(fromName);
        fromAddress.foreach(arg_0 -> ((ServiceDeskEmail.Builder)builder).fromAddress(arg_0));
        return Option.some((Object)builder.build());
    }
}

