/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.CommentNotificationUtils;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentPropertyService;
import com.atlassian.servicedesk.internal.notifications.InternalCommentNotificationsUtils;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CommentNotificationUtilsImpl
implements CommentNotificationUtils,
InternalCommentNotificationsUtils {
    private final ServiceDeskCommentPropertyService sdCommentPropertyService;
    private final LoggingSupport loggingSupport;

    @Autowired
    public CommentNotificationUtilsImpl(ServiceDeskCommentPropertyService sdCommentPropertyService, LoggingSupport loggingSupport) {
        this.sdCommentPropertyService = sdCommentPropertyService;
        this.loggingSupport = loggingSupport;
    }

    @Override
    public Map<String, JSONObject> createEmailPropertyMap(List<String> emailList) {
        JSONObject jsonObj = new JSONObject();
        for (String email : emailList) {
            try {
                jsonObj.put(StringUtils.lowerCase((String)email), true);
            }
            catch (JSONException e) {
                this.loggingSupport.log().error("Email can never be null", (Throwable)e);
            }
        }
        return ImmutableMap.of((Object)"sd.comment.email.email.list", (Object)jsonObj);
    }

    public boolean isUserNotInEmailListOfCreatedComment(CheckedUser recipient, Comment comment) {
        boolean isCommentCreated;
        boolean bl = isCommentCreated = comment.getCreated().compareTo(comment.getUpdated()) == 0;
        if (isCommentCreated) {
            String lowercaseEmail = StringUtils.lowerCase((String)recipient.getEmailAddress());
            Option<JSONObject> sdEmailListOpt = this.sdCommentPropertyService.getSDCommentProperty(comment, "sd.comment.email.email.list");
            Option<JSONObject> jiraEmailListOpt = this.sdCommentPropertyService.getJIRACommentProperty(recipient.forJIRA(), comment, "sd.comment.email.email.list");
            boolean userInCCList = sdEmailListOpt.exists(originalEmailRecipients -> originalEmailRecipients.has(lowercaseEmail)) || jiraEmailListOpt.exists(originalEmailRecipients -> originalEmailRecipients.has(lowercaseEmail));
            return !userInCCList;
        }
        return true;
    }
}

