/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.listener;

import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationEventHandler;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskDeletionManager;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectEventListener {
    private ServiceDeskDeletionManager serviceDeskDeletionManager;
    private CustomerOrganizationEventHandler customerOrganizationEventHandler;
    private SafeRunner safeRunner;

    @Autowired
    public ProjectEventListener(ServiceDeskDeletionManager serviceDeskDeletionManager, CustomerOrganizationEventHandler customerOrganizationEventHandler, SafeRunner safeRunner) {
        this.serviceDeskDeletionManager = serviceDeskDeletionManager;
        this.customerOrganizationEventHandler = customerOrganizationEventHandler;
        this.safeRunner = safeRunner;
    }

    public void onProjectCreate(ProjectCreatedEvent createProjectEvent) {
    }

    public void onProjectDelete(final ProjectDeletedEvent deleteProjectEvent) {
        this.safeRunner.run(new Runnable(){
            Long id;
            String key;
            {
                this.id = deleteProjectEvent.getId();
                this.key = deleteProjectEvent.getKey();
            }

            @Override
            public void run() {
                ProjectEventListener.this.serviceDeskDeletionManager.deleteServiceDeskByProject(this.id, this.key);
            }
        });
        this.safeRunner.run(() -> this.customerOrganizationEventHandler.onProjectDeleteEvent(deleteProjectEvent));
    }
}

