/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.listener;

import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarDeletedEvent;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarEvent;
import com.atlassian.jira.plugins.workinghours.api.calendar.event.CalendarUpdatedEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.ServiceDeskCalendarContextHelper;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.task.SlaDataConsistencyManager;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarEventListener {
    Log log = Log.with(this.getClass());
    @Autowired
    SafeRunner safeRunner;
    @Autowired
    CalendarReferenceManager calendarReferenceManager;
    @Autowired
    GoalManager goalManager;
    @Autowired
    ServiceDeskCalendarContextHelper serviceDeskCalendarContextHelper;
    @Autowired
    SlaDataConsistencyManager slaDataConsistencyManager;
    @Autowired
    JiraAuthenticationContext jiraAuthenticationContext;

    public void onCalendarDeleted(final CalendarDeletedEvent calendarEvent) {
        this.safeRunner.run(new Runnable(){

            @Override
            public void run() {
                CalendarEventListener.this.logDebug((CalendarEvent)calendarEvent);
                CalendarEventListener.this.updateGoals((CalendarEvent)calendarEvent);
            }
        });
    }

    public void onCalendarUpdated(final CalendarUpdatedEvent calendarEvent) {
        this.safeRunner.run(new Runnable(){

            @Override
            public void run() {
                CalendarEventListener.this.logDebug((CalendarEvent)calendarEvent);
                CalendarEventListener.this.updateGoals((CalendarEvent)calendarEvent);
            }
        });
    }

    private void logDebug(CalendarEvent calendarEvent) {
        this.log.debug("Received calendar event %s with calendar '%s' and id %d", new Object[]{calendarEvent.getClass().getSimpleName(), calendarEvent.getCalendar().getName(), calendarEvent.getCalendar().getId()});
    }

    private void updateGoals(CalendarEvent calendarEvent) {
        Option<ServiceDesk> serviceDesk = this.serviceDeskCalendarContextHelper.getServiceDesk(calendarEvent.getCalendar().getContext());
        if (serviceDesk.isEmpty()) {
            return;
        }
        CalendarReference reference = this.calendarReferenceManager.getReferenceForCalendar(calendarEvent.getCalendar());
        List<Goal> affectedGoals = this.goalManager.getByCalendar(reference);
        if (affectedGoals.isEmpty()) {
            return;
        }
        DateTime now = DateTime.now();
        this.goalManager.updateTimeUpdatedDateAndMsEpoch(affectedGoals, now);
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user != null) {
            this.slaDataConsistencyManager.requestConsistencyCheck(user, (ServiceDesk)serviceDesk.get(), (Option<SlaAuditLogReason>)Option.some((Object)((Object)SlaAuditLogReason.CALENDAR_CHANGED)));
        }
    }
}

