/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.license;

import com.atlassian.servicedesk.internal.api.license.ServiceDeskLicenseState;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;

public class ServiceDeskLicenseStateHelper {
    public static ServiceDeskLicenseState getServiceDeskLicenseState(String licenseString) {
        return new ServiceDeskLicenseStateImpl(licenseString);
    }

    public static boolean equals(ServiceDeskLicenseState oldState, ServiceDeskLicenseState newState) {
        if (oldState == null) {
            return newState == null || !newState.isLicensePresent();
        }
        return newState != null && newState.equals(oldState);
    }

    private static class ServiceDeskLicenseStateImpl
    implements ServiceDeskLicenseState {
        private final Option<String> licenseString;

        private ServiceDeskLicenseStateImpl(String licenseString) {
            this.licenseString = StringUtils.isBlank((String)licenseString) ? Option.none() : Option.some((Object)licenseString);
        }

        public boolean isLicensePresent() {
            return this.licenseString.isDefined();
        }

        public boolean equals(ServiceDeskLicenseState state) {
            if (state == null) {
                return this.licenseString.isEmpty();
            }
            return state instanceof ServiceDeskLicenseStateImpl && ((ServiceDeskLicenseStateImpl)state).licenseString.equals(this.licenseString);
        }
    }
}

