/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.license;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskLicenseState;
import com.atlassian.servicedesk.internal.license.ServiceDeskLicenseStateHelper;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ServiceDeskApplicationLicenseServiceImpl
implements ServiceDeskApplicationLicenseService {
    private final ApplicationRoleManager applicationRoleManager;
    private final ApplicationAuthorizationService applicationAuthorizationService;
    private final JiraLicenseManager jiraLicenseManager;
    private final RequestCache<String, Boolean> requestCache;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"dd-MM-yyyy");
    private static final String IS_AGENT_LICENSE_LIMIT_EXCEEDED_CACHE_KEY = "isAgentLicenseLimitExceeded";
    private static final String IS_LICENSE_VALID_CACHE_KEY = "isLicenseValid";

    @Autowired
    public ServiceDeskApplicationLicenseServiceImpl(ApplicationRoleManager applicationRoleManager, ApplicationAuthorizationService applicationAuthorizationService, JiraLicenseManager jiraLicenseManager, VCacheFactory vCacheFactory) {
        this.applicationRoleManager = applicationRoleManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.jiraLicenseManager = jiraLicenseManager;
        this.requestCache = vCacheFactory.getRequestCache(CacheUtil.standardName(this, "licensingCache"));
    }

    public int getActiveAgentCount() {
        return this.applicationAuthorizationService.getUserCount(SERVICEDESK_KEY);
    }

    public boolean isAgentLimitExceeded() {
        return (Boolean)this.requestCache.get((Object)IS_AGENT_LICENSE_LIMIT_EXCEEDED_CACHE_KEY, () -> this.applicationAuthorizationService.isExceeded(SERVICEDESK_KEY));
    }

    public Set<Group> getDefaultAgentGroups() {
        return this.applicationRoleManager.getDefaultGroups(SERVICEDESK_KEY);
    }

    public Integer getAgentLicenseCapacityOrUnlimited() {
        if (this.isAgentLicenseCapacityUnlimited()) {
            return UNLIMITED_LICENCE_CAPACITY;
        }
        return this.getAgentLicenseCapacity();
    }

    private int getAgentLicenseCapacity() {
        int agentLicenseCapacity = 0;
        io.atlassian.fugue.Option applicationRoleOption = StepsConverters.newerOption((Option)this.applicationRoleManager.getRole(SERVICEDESK_KEY));
        if (applicationRoleOption.isDefined()) {
            agentLicenseCapacity = ((ApplicationRole)applicationRoleOption.get()).getNumberOfSeats();
        }
        return agentLicenseCapacity;
    }

    public boolean isAgentLicenseCapacityUnlimited() {
        return this.getAgentLicenseCapacity() == -1;
    }

    public boolean areAllAgentLicensesUsed() {
        int remaining = this.applicationRoleManager.getRemainingSeats(SERVICEDESK_KEY);
        return remaining == 0;
    }

    public ServiceDeskLicenseState getServiceDeskLicenseState() {
        io.atlassian.fugue.Option<LicenseDetails> sdApplicationLicenseDetailsOpt = this.getServiceDeskApplicationLicenseDetails();
        String licenseString = null;
        if (sdApplicationLicenseDetailsOpt.isDefined()) {
            licenseString = ((LicenseDetails)sdApplicationLicenseDetailsOpt.get()).getLicenseString();
        }
        return ServiceDeskLicenseStateHelper.getServiceDeskLicenseState(licenseString);
    }

    public boolean isLicenseValid() {
        return (Boolean)this.requestCache.get((Object)IS_LICENSE_VALID_CACHE_KEY, this::hasNoLicenseErrors);
    }

    private boolean hasNoLicenseErrors() {
        Set errors = this.applicationAuthorizationService.getLicensingAccessErrors(SERVICEDESK_KEY);
        for (ApplicationAccess.AccessError e : errors) {
            if (e == ApplicationAccess.AccessError.USERS_EXCEEDED) continue;
            return false;
        }
        return true;
    }

    public String getLicenseSummary() {
        io.atlassian.fugue.Option<LicenseDetails> licenseDetailsOpt = this.getServiceDeskApplicationLicenseDetails();
        if (licenseDetailsOpt.isEmpty()) {
            return "No License";
        }
        LicenseDetails licenseDetails = (LicenseDetails)licenseDetailsOpt.get();
        boolean valid = this.hasNoLicenseErrors();
        int userCount = this.getAgentLicenseCapacity();
        StringBuilder sb = new StringBuilder();
        sb.append("\nDescription        : ").append(licenseDetails.getDescription()).append("\nType               : ").append(licenseDetails.getLicenseType().toString()).append("\nValid              : ").append(valid).append("\nMaintenance Expiry : ").append(licenseDetails.getMaintenanceExpiryDate() == null ? "Not Available" : DATE_FORMAT.print(licenseDetails.getMaintenanceExpiryDate().getTime())).append("\nMaximum Users      : ").append(userCount == -1 ? "Unlimited" : Integer.valueOf(userCount)).append("\nOrganisation       : ").append(licenseDetails.getOrganisation()).append("\nSEN                : ").append(licenseDetails.getSupportEntitlementNumber());
        if (licenseDetails.isEvaluation()) {
            int days = licenseDetails.getDaysToLicenseExpiry();
            sb.append("\nExpires In         : ").append(days).append(days == 1 ? " day" : " days");
        }
        return sb.toString();
    }

    public boolean isEvaluationLicense() {
        io.atlassian.fugue.Option<LicenseDetails> licenseDetailsOpt = this.getServiceDeskApplicationLicenseDetails();
        return (Boolean)licenseDetailsOpt.map(LicenseDetails::isEvaluation).getOrElse((Object)false);
    }

    private io.atlassian.fugue.Option<LicenseDetails> getServiceDeskApplicationLicenseDetails() {
        return StepsConverters.newerOption((Option)this.jiraLicenseManager.getLicense(SERVICEDESK_KEY));
    }

    public io.atlassian.fugue.Option<String> getDescriptiveLicenseError() {
        if (this.hasNoLicenseErrors()) {
            return io.atlassian.fugue.Option.none();
        }
        List accessErrors = this.applicationAuthorizationService.getLicensingAccessErrors(SERVICEDESK_KEY).stream().map(this::getAccessErrorDescription).collect(Collectors.toList());
        return io.atlassian.fugue.Option.some((Object)String.join((CharSequence)", ", accessErrors));
    }

    private String getAccessErrorDescription(ApplicationAccess.AccessError error) {
        switch (error) {
            case EXPIRED: {
                return "Service Desk license is expired";
            }
            case UNLICENSED: {
                return "Service Desk is unlicensed";
            }
            case VERSION_MISMATCH: {
                return "The Service Desk license cannot be used with the current version of JIRA or Service Desk (maintenance date expired)";
            }
        }
        return error.toString();
    }
}

