/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.lessuriresolver;

import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBranding;
import com.atlassian.servicedesk.internal.lessuriresolver.LookAndFeelService;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LookAndFeelServiceImpl
implements LookAndFeelService {
    private static final String LOOK_AND_FEEL = "com.atlassian.servicedesk.lookandfeel";
    private static final String HEADER_BG_COLOR = "headerBGColor";
    private static final String HEADER_LINK_COLOR = "headerLinkColor";
    private static final String HEADER_LINK_HOVER_BG_COLOR = "headerLinkHoverBGColor";
    private static final String HEADER_LINK_HOVER_COLOR = "headerLinkHoverColor";
    private static final String DEFAULT_HASH = "default";
    private final GlobalPropertyDao globalPropertyDao;

    @Autowired
    public LookAndFeelServiceImpl(GlobalPropertyDao globalPropertyDao) {
        this.globalPropertyDao = globalPropertyDao;
    }

    @Override
    public void processLookAndFeelChange(HelpCenterBranding helpCenterBranding) {
        String hashValue = this.calculateLookAndFeelHash(helpCenterBranding);
        this.setLnFHashValue(hashValue);
    }

    private void setLnFHashValue(String hashValue) {
        this.globalPropertyDao.setTextProperty(LOOK_AND_FEEL, hashValue);
    }

    @Override
    public String getLnFHashValue() {
        return StringUtils.defaultIfBlank((String)this.globalPropertyDao.getTextProperty(LOOK_AND_FEEL), (String)DEFAULT_HASH);
    }

    private String calculateLookAndFeelHash(HelpCenterBranding helpCenterBranding) {
        HashBuilder md5hash = new HashBuilder();
        this.addToHash(md5hash, HEADER_BG_COLOR, helpCenterBranding.getHeaderBGColor());
        this.addToHash(md5hash, HEADER_LINK_COLOR, helpCenterBranding.getHeaderLinkColor());
        this.addToHash(md5hash, HEADER_LINK_HOVER_BG_COLOR, helpCenterBranding.getHeaderLinkHoverBGColor());
        this.addToHash(md5hash, HEADER_LINK_HOVER_COLOR, helpCenterBranding.getHeaderLinkHoverColor());
        return md5hash.build();
    }

    private HashBuilder addToHash(HashBuilder md5hash, String key, Option<String> value) {
        if (value.isDefined()) {
            md5hash.add(key);
            md5hash.add("=");
            md5hash.add((String)value.get());
        }
        return md5hash;
    }
}

