/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.lessuriresolver;

import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBranding;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import io.atlassian.fugue.Option;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LookAndFeelLessUriResolver
implements UriResolver {
    public static final String LOOK_AND_FEEL_URI = "dynamic://com.atlassian.servicedesk.internal.lookandfeel/dynamic-branding-variables.less";
    private static final String CHARSET = "UTF-8";
    private final String HEADER_BACKGROUND_VARIABLE_NAME = "customHeaderBackground";
    private final String HEADER_TEXT_VARIABLE_NAME = "customHeaderText";
    private final String HEADER_HOVER_BACKGROUND_VARIABLE_NAME = "customHeaderHoverBackground";
    private final String HEADER_HOVER_TEXT_VARIABLE_NAME = "customHeaderHoverText";
    private HelpCenterBrandingManagerScala helpCenterBrandingManager;

    @Autowired
    public LookAndFeelLessUriResolver(HelpCenterBrandingManagerScala helpCenterBrandingManager) {
        this.helpCenterBrandingManager = helpCenterBrandingManager;
    }

    public boolean exists(URI uri) {
        return uri.toString().equals(LOOK_AND_FEEL_URI);
    }

    public String encodeState(URI uri) {
        return this.helpCenterBrandingManager.getHelpCenterBranding().toString();
    }

    public InputStream open(URI uri) throws IOException {
        StringBuilder sb = new StringBuilder();
        HelpCenterBranding helpCenterBranding = this.helpCenterBrandingManager.getHelpCenterBranding();
        this.writeVariableToLess("customHeaderBackground", this.getStringFromOption(helpCenterBranding.getHeaderBGColor()), sb);
        this.writeVariableToLess("customHeaderText", this.getStringFromOption(helpCenterBranding.getHeaderLinkColor()), sb);
        this.writeVariableToLess("customHeaderHoverBackground", this.getStringFromOption(helpCenterBranding.getHeaderLinkHoverBGColor()), sb);
        this.writeVariableToLess("customHeaderHoverText", this.getStringFromOption(helpCenterBranding.getHeaderLinkHoverColor()), sb);
        return new ByteArrayInputStream(sb.toString().getBytes(CHARSET));
    }

    public boolean supports(URI uri) {
        return uri.toString().equals(LOOK_AND_FEEL_URI);
    }

    private void writeVariableToLess(String variableName, String value, StringBuilder sb) {
        if (StringUtils.isNotEmpty((String)value)) {
            sb.append('@').append(variableName).append(':').append(value).append(';');
        } else {
            sb.append('@').append(variableName).append(':').append("").append(';');
        }
    }

    private String getStringFromOption(Option<String> option) {
        return (String)option.getOrElse((Object)"");
    }
}

