/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue.listeners;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.fugue.Either;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.channel.IssueChannelService;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.util.IssueEventTypeHelper;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssuePropertiesIssueEventListener {
    private static final Logger log = LoggerFactory.getLogger(IssuePropertiesIssueEventListener.class);
    private static final String INCIDENT_NAME = "incident";
    private static final String NO_SOURCE = "unknown";
    private static final String ERROR_SOURCE = "error";
    private final UserFactory userFactory;
    private final IssueChannelService issueChannelService;
    private final ServiceDeskInternalManager internalServiceDeskManager;
    private final IssueEventTypeHelper issueEventTypeHelper;
    private final AnalyticsService analyticsService;

    @Autowired
    public IssuePropertiesIssueEventListener(UserFactory userFactory, IssueChannelService issueChannelService, ServiceDeskInternalManager internalServiceDeskManager, IssueEventTypeHelper issueEventTypeHelper, AnalyticsService analyticsService) {
        this.userFactory = userFactory;
        this.issueChannelService = issueChannelService;
        this.internalServiceDeskManager = internalServiceDeskManager;
        this.issueEventTypeHelper = issueEventTypeHelper;
        this.analyticsService = analyticsService;
    }

    public void onIssueEvent(IssueEvent issueEvent) {
        if (this.issueEventTypeHelper.isEventOfType(issueEvent, EventType.ISSUE_CREATED_ID) && Option.option((Object)issueEvent.getIssue()).isDefined() && Option.option((Object)issueEvent.getProject()).isDefined() && this.internalServiceDeskManager.hasServiceDesk(issueEvent.getProject(), false)) {
            io.atlassian.fugue.Either channelEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrapUnchecked(issueEvent.getUser()))).then(unchecked -> this.issueChannelService.setChannelToIssueCreatedByJira((SDUser)unchecked, issueEvent.getIssue())).yield((uncheckedUser, customerRequestChannelSource) -> customerRequestChannelSource);
            Long issueId = issueEvent.getIssue().getId();
            Long projectId = issueEvent.getProject().getId();
            String issueTypeName = this.extractIssueTypeName(issueEvent.getIssue());
            channelEither.left().foreach(error -> {
                log.warn("There was a problem processing the Customer Request Channel Source for issue {} in event listener : {}", (Object)issueEvent.getIssue().getId(), error);
                this.fireAnalyticEvent(issueId, projectId, issueTypeName, ERROR_SOURCE);
            });
            channelEither.foreach(channelOption -> {
                Option channel = channelOption.map(CustomerRequestChannelSource::value);
                if (channel.isEmpty()) {
                    log.warn("There is no Customer Request Channel Source stored for new created issue {}", (Object)issueId);
                }
                String channelValue = (String)channel.getOrElse((Object)NO_SOURCE);
                log.debug("Customer Request Channel Source for issue {} is '{}'", (Object)issueId, (Object)channelValue);
                this.fireAnalyticEvent(issueId, projectId, issueTypeName, channelValue);
            });
        }
    }

    private void fireAnalyticEvent(Long issueId, Long projectId, String issueTypeName, String channelValue) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new ServiceDeskIssueCreatedEvent(projectId, issueId, StringUtils.containsIgnoreCase((String)issueTypeName, (String)INCIDENT_NAME), channelValue));
    }

    private String extractIssueTypeName(Issue issue) {
        return (String)Option.option((Object)issue.getIssueType()).map(IssueConstant::getName).getOrElse((Object)"");
    }

    @EventName(value="servicedesk.event.issue.created")
    @VisibleForTesting
    static class ServiceDeskIssueCreatedEvent
    extends AnalyticsEvent {
        private final Long projectId;
        private final Long issueId;
        private final Boolean isIncident;
        private final String channel;

        ServiceDeskIssueCreatedEvent(@Nonnull Long projectId, @Nonnull Long issueId, @Nonnull Boolean isIncident, @Nonnull String channel) {
            this.projectId = projectId;
            this.isIncident = isIncident;
            this.issueId = issueId;
            this.channel = channel;
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public String getChannel() {
            return this.channel;
        }

        public Boolean getIsIncident() {
            return this.isIncident;
        }

        public Long getIssueId() {
            return this.issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServiceDeskIssueCreatedEvent)) {
                return false;
            }
            ServiceDeskIssueCreatedEvent that = (ServiceDeskIssueCreatedEvent)((Object)o);
            return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.issueId, that.issueId) && Objects.equals(this.isIncident, that.isIncident) && Objects.equals(this.channel, that.channel);
        }

        public int hashCode() {
            return Objects.hash(this.projectId, this.issueId, this.isIncident, this.channel);
        }
    }
}

