/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue.listeners;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Pair;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueInitialFieldSetStateListener {
    private static final Logger log = LoggerFactory.getLogger(IssueInitialFieldSetStateListener.class);
    private static final Set<String> FIELD_OF_INTEREST = ImmutableSet.of((Object)"resolution", (Object)"assignee");
    private static final Pair<Boolean, io.atlassian.fugue.Option<String>> NONE_PAIR = Pair.pair((Object)false, (Object)io.atlassian.fugue.Option.none());
    @VisibleForTesting
    static final String KEY = "sd.initial.field.set";
    @VisibleForTesting
    static final String FLAG_JSON_KEY = "sd.initial.checked";
    @VisibleForTesting
    static final EntityPropertyOptions SKIP_PERMISSIONS = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
    private final IssuePropertyService issuePropertyService;
    private final IssueEventHelper issueEventHelper;
    private final IssueManager issueManager;

    @Autowired
    public IssueInitialFieldSetStateListener(IssuePropertyService issuePropertyService, IssueEventHelper issueEventHelper, IssueManager issueManager) {
        this.issuePropertyService = issuePropertyService;
        this.issueEventHelper = issueEventHelper;
        this.issueManager = issueManager;
    }

    public void onIssueEvent(IssueEvent issueEvent) {
        if (!this.issueEventHelper.isCreatedEvent(issueEvent)) {
            return;
        }
        if (issueEvent.getIssue() == null) {
            return;
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueEvent.getIssue().getId());
        io.atlassian.fugue.Option resolutionOption = io.atlassian.fugue.Option.option((Object)issue.getResolutionId());
        io.atlassian.fugue.Option assigneeOption = io.atlassian.fugue.Option.option((Object)issue.getAssigneeId());
        try {
            JSONObject initialStateJson = new JSONObject();
            this.putIntoJsonObject(initialStateJson, FLAG_JSON_KEY, "");
            resolutionOption.forEach(resolutionId -> this.putIntoJsonObject(initialStateJson, "resolution", (String)resolutionId));
            assigneeOption.forEach(assigneeId -> this.putIntoJsonObject(initialStateJson, "assignee", (String)assigneeId));
            EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(initialStateJson.toString(), KEY);
            EntityPropertyService.SetPropertyValidationResult setPropertyValidationResult = this.issuePropertyService.validateSetProperty(issueEvent.getUser(), issue.getId(), propertyInput, SKIP_PERMISSIONS);
            if (setPropertyValidationResult.isValid()) {
                this.issuePropertyService.setProperty(issueEvent.getUser(), setPropertyValidationResult);
            } else {
                log.debug("SetPropertyValidationResult result invalid for {} on issue id {}", (Object)KEY, (Object)issue.getId());
            }
        }
        catch (Exception e) {
            log.warn("Exception while trying to save JSON issue property sd.initial.field.set", (Throwable)e);
        }
    }

    public Pair<Boolean, io.atlassian.fugue.Option<String>> isFieldSetOnIssueCreation(ApplicationUser user, Issue issue, String field) {
        if (!FIELD_OF_INTEREST.contains(field)) {
            return NONE_PAIR;
        }
        EntityPropertyService.PropertyResult property = this.issuePropertyService.getProperty(user, issue.getId(), KEY, SKIP_PERMISSIONS);
        if (property.isValid()) {
            return (Pair)StepsConverters.newerOption((Option)property.getEntityProperty()).map(EntityProperty::getValue).flatMap(value -> {
                try {
                    return io.atlassian.fugue.Option.some((Object)new JSONObject(value));
                }
                catch (JSONException e) {
                    log.warn("Exception while trying to get JSON issue property sd.initial.field.set", (Throwable)e);
                    return io.atlassian.fugue.Option.none();
                }
            }).fold(() -> NONE_PAIR, jsonObject -> {
                if (this.checkFlagKeyInJsonObject((JSONObject)jsonObject)) {
                    return Pair.pair((Object)true, this.readOptionalStringFromJsonObject((JSONObject)jsonObject, field));
                }
                return NONE_PAIR;
            });
        }
        log.debug("getProperty result invalid for {} on issue id {}", (Object)KEY, (Object)issue.getId());
        return NONE_PAIR;
    }

    private boolean checkFlagKeyInJsonObject(JSONObject jsonObject) {
        return jsonObject.has(FLAG_JSON_KEY);
    }

    private io.atlassian.fugue.Option<String> readOptionalStringFromJsonObject(JSONObject jsonObject, String key) {
        return io.atlassian.fugue.Option.option((Object)jsonObject.optString(key)).filter(StringUtils::isNotBlank);
    }

    private JSONObject putIntoJsonObject(JSONObject jsonObject, String key, String value) {
        try {
            return jsonObject.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

