/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue.issuelist;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.Nonnull;

public class ServiceDeskIssueList {
    private final List<Issue> issues;
    private final List<NavigableField> columns;
    private final int total;
    private final int start;
    private final int end;
    private final String issueHash;

    private ServiceDeskIssueList(Builder builder) {
        Assertions.notNull((String)"issues", (Object)builder.issues);
        Assertions.notNull((String)"columns", (Object)builder.columns);
        Assertions.notNull((String)"issueHash", (Object)builder.issueHash);
        this.issues = builder.issues;
        this.columns = builder.columns;
        this.total = builder.total;
        this.start = builder.start;
        this.end = builder.end;
        this.issueHash = builder.issueHash;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public List<NavigableField> getColumns() {
        return this.columns;
    }

    public int getTotal() {
        return this.total;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getIssueHash() {
        return this.issueHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceDeskIssueList)) {
            return false;
        }
        ServiceDeskIssueList that = (ServiceDeskIssueList)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.total != that.total) {
            return false;
        }
        if (!this.columns.equals(that.columns)) {
            return false;
        }
        if (!this.issueHash.equals(that.issueHash)) {
            return false;
        }
        return this.issues.equals(that.issues);
    }

    public int hashCode() {
        int result = this.issues.hashCode();
        result = 31 * result + this.columns.hashCode();
        result = 31 * result + this.total;
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.issueHash.hashCode();
        return result;
    }

    public static class Builder {
        private List<Issue> issues;
        private List<NavigableField> columns;
        private int total;
        private int start;
        private int end;
        private String issueHash;

        public Builder issues(@Nonnull List<Issue> issues) {
            Assertions.notNull((String)"issues", issues);
            this.issues = issues;
            return this;
        }

        public Builder columns(@Nonnull List<NavigableField> columns) {
            Assertions.notNull((String)"columns", columns);
            this.columns = columns;
            return this;
        }

        public Builder total(int total) {
            Assertions.isTrue((String)"total must be >= 0", (total >= 0 ? 1 : 0) != 0);
            this.total = total;
            return this;
        }

        public Builder start(int start) {
            Assertions.isTrue((String)"start must be >= 0", (start >= 0 ? 1 : 0) != 0);
            this.start = start;
            return this;
        }

        public Builder end(int end) {
            Assertions.isTrue((String)"end must be >= 0", (end >= 0 ? 1 : 0) != 0);
            this.end = end;
            return this;
        }

        public Builder issueHash(String issueHash) {
            Assertions.notNull((String)"issueHash", (Object)issueHash);
            this.issueHash = issueHash;
            return this;
        }

        public ServiceDeskIssueList build() {
            return new ServiceDeskIssueList(this);
        }
    }
}

