/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue.issuelist;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHashData;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueSearchServiceImpl;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldService;
import com.atlassian.servicedesk.internal.issue.issuelist.IssueListHasher;
import com.atlassian.servicedesk.internal.issue.issuelist.IssueListService;
import com.atlassian.servicedesk.internal.issue.issuelist.IssueListVisualiser;
import com.atlassian.servicedesk.internal.issue.issuelist.ServiceDeskIssueList;
import com.atlassian.servicedesk.internal.issue.issuelist.views.ServiceDeskIssueListView;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueListServiceImpl
implements IssueListService {
    private final ServiceDeskIssueSearchServiceImpl searchService;
    private final ServiceDeskJIRAFieldService jiraFieldService;
    private final IssueListVisualiser issueListVisualiser;
    private final IssueListHasher issueListHasher;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ProjectService projectService;
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final ErrorResultHelper errorHelper;
    private static final String EMPTY_ISSUE_HASH = "empty";

    @Autowired
    public IssueListServiceImpl(ServiceDeskIssueSearchServiceImpl searchService, ServiceDeskJIRAFieldService jiraFieldService, IssueListVisualiser issueListVisualiser, IssueListHasher issueListHasher, ServiceDeskPermissionService serviceDeskPermissionService, ProjectService projectService, ServiceDeskIssueService serviceDeskIssueService, ErrorResultHelper errorHelper) {
        this.searchService = searchService;
        this.jiraFieldService = jiraFieldService;
        this.issueListVisualiser = issueListVisualiser;
        this.issueListHasher = issueListHasher;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.projectService = projectService;
        this.serviceDeskIssueService = serviceDeskIssueService;
        this.errorHelper = errorHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ServiceDeskIssueList> getIssueList(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull String jql, @Nonnull List<String> columns, int startIndex, int issuesPerPage) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"serviceDesk", (Object)serviceDesk);
        Assertions.notNull((String)"jql", (Object)jql);
        Assertions.notNull((String)"columns", columns);
        io.atlassian.fugue.Either agentPermissionResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user.forJIRA(), serviceDesk));
        if (agentPermissionResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)agentPermissionResult.left().get());
        }
        Boolean isAgent2 = (Boolean)agentPermissionResult.right().get();
        if (!isAgent2.booleanValue()) {
            return io.atlassian.fugue.Either.left((Object)this.errorHelper.forbidden403("sd.issue.search.nonagent", new Object[0]).build());
        }
        io.atlassian.fugue.Either<AnError, String> completeJqlEither = this.scopeJqlToProjectScope(jql, user, serviceDesk);
        if (completeJqlEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)completeJqlEither.left().get());
        }
        String completeJql = (String)completeJqlEither.right().get();
        io.atlassian.fugue.Either<AnError, Query> parseQueryResult = this.searchService.parseQuery(user, completeJql);
        if (parseQueryResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)parseQueryResult.left().get());
        }
        Query query = (Query)parseQueryResult.right().get();
        io.atlassian.fugue.Either<AnError, SearchResults> searchResultsEither = this.searchService.getIssues(user, serviceDesk, query, startIndex, issuesPerPage);
        if (searchResultsEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)searchResultsEither.left().get());
        }
        SearchResults searchResults = (SearchResults)searchResultsEither.right().get();
        List<IssueHashData> issueHashData = this.convertSearchResultsToIssueHashData(searchResults);
        String calculatedIssueHash = this.calculateIssueHash(issueHashData, searchResults.getTotal());
        List<NavigableField> navigableFields = this.getNavigableFields(user, columns);
        ServiceDeskIssueList issueList = this.buildIssueList(searchResults, navigableFields, calculatedIssueHash);
        return io.atlassian.fugue.Either.right((Object)issueList);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Option<ServiceDeskIssueList>> getIssueListIfUpdated(@Nonnull CheckedUser user, @Nonnull ServiceDesk serviceDesk, @Nonnull String jql, @Nonnull List<String> columns, int startIndex, int issuesPerPage, @Nonnull String issueHash) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"serviceDesk", (Object)serviceDesk);
        Assertions.notNull((String)"jql", (Object)jql);
        Assertions.notNull((String)"columns", columns);
        Assertions.notNull((String)"issueHash", (Object)issueHash);
        io.atlassian.fugue.Either agentPermissionResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user.forJIRA(), serviceDesk));
        if (agentPermissionResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)agentPermissionResult.left().get());
        }
        Boolean isAgent2 = (Boolean)agentPermissionResult.right().get();
        if (!isAgent2.booleanValue()) {
            return io.atlassian.fugue.Either.left((Object)this.errorHelper.forbidden403("sd.issue.search.nonagent", new Object[0]).build());
        }
        io.atlassian.fugue.Either<AnError, String> completeJqlEither = this.scopeJqlToProjectScope(jql, user, serviceDesk);
        if (completeJqlEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)completeJqlEither.left().get());
        }
        String completeJql = (String)completeJqlEither.right().get();
        io.atlassian.fugue.Either<AnError, Query> parseQueryResult = this.searchService.parseQuery(user, completeJql);
        if (parseQueryResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)parseQueryResult.left().get());
        }
        Query query = (Query)parseQueryResult.right().get();
        io.atlassian.fugue.Either<AnError, List<IssueHashData>> issueResultsEither = this.searchService.getIssueHashData(user, serviceDesk, query, startIndex, issuesPerPage);
        if (issueResultsEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)issueResultsEither.left().get());
        }
        List issueResults = (List)issueResultsEither.right().get();
        io.atlassian.fugue.Either<AnError, Long> issueCountResult = this.searchService.countIssues(user, serviceDesk, query);
        if (issueCountResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)issueCountResult.left().get());
        }
        long totalIssueCount = (Long)issueCountResult.right().get();
        String calculatedIssueHash = this.calculateIssueHash(issueResults, totalIssueCount);
        if (calculatedIssueHash.equals(issueHash)) {
            return io.atlassian.fugue.Either.right((Object)Option.none(ServiceDeskIssueList.class));
        }
        io.atlassian.fugue.Either<AnError, SearchResults> searchResultsEither = this.searchService.getIssues(user, serviceDesk, query, startIndex, issuesPerPage);
        if (searchResultsEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)searchResultsEither.left().get());
        }
        SearchResults searchResults = (SearchResults)searchResultsEither.right().get();
        List<NavigableField> navigableFields = this.getNavigableFields(user, columns);
        ServiceDeskIssueList issueList = this.buildIssueList(searchResults, navigableFields, calculatedIssueHash);
        return io.atlassian.fugue.Either.right((Object)Option.some((Object)issueList));
    }

    @Override
    public ServiceDeskIssueListView getIssueListView(CheckedUser user, ServiceDeskIssueList issueList) {
        return this.issueListVisualiser.getIssueListView(user, issueList);
    }

    private List<NavigableField> getNavigableFields(CheckedUser user, List<String> columns) {
        return this.jiraFieldService.getNavigableFields(user, columns);
    }

    private ServiceDeskIssueList buildIssueList(SearchResults searchResults, List<NavigableField> navigableFields, String issueHash) {
        return ServiceDeskIssueList.builder().issues(searchResults.getIssues()).columns(navigableFields).total(searchResults.getTotal()).start(searchResults.getStart()).end(searchResults.getEnd()).issueHash(issueHash).build();
    }

    private io.atlassian.fugue.Either<AnError, String> scopeJqlToProjectScope(String jql, CheckedUser user, ServiceDesk serviceDesk) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectById(user.forJIRA(), Long.valueOf(serviceDesk.getProjectId()));
        if (!projectResult.isValid()) {
            return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "sd.error.project.not.found", new Object[]{serviceDesk.getProjectId()}));
        }
        return io.atlassian.fugue.Either.right((Object)this.serviceDeskIssueService.limitToProject(user, jql, projectResult.getProject()));
    }

    private List<IssueHashData> convertSearchResultsToIssueHashData(SearchResults searchResults) {
        return Lists.transform((List)searchResults.getIssues(), (Function)new Function<Issue, IssueHashData>(){

            public IssueHashData apply(Issue issue) {
                return new IssueHashData(issue.getKey(), issue.getUpdated());
            }
        });
    }

    private String calculateIssueHash(List<IssueHashData> issueData, long totalIssueCount) {
        if (issueData.isEmpty()) {
            return EMPTY_ISSUE_HASH;
        }
        return this.issueListHasher.hash(issueData, totalIssueCount);
    }
}

