/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.activitystream.providers.StatusAndResolutionActivityProvider;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.notifications.IssueConversationalNotificationManager;
import com.atlassian.servicedesk.internal.util.IssueEventTypeHelper;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskIssueEventEmailNotifier {
    private final UserFactory userFactory;
    private final IssueConversationalNotificationManager conversationalNotificationManager;
    private final PortalInternalManager portalInternalManager;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final IssueEventTypeHelper issueEventTypeHelper;
    private final CommentService commentService;
    private final InternalSDCommentManager internalSDCommentManager;
    private final RequestParticipantsInternalManager requestParticipantsInternalManager;
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;
    private final StatusAndResolutionActivityProvider statusAndResolutionActivityProvider;
    private final SafeRunner safeRunner;
    private final CustomerContextService customerContextService;
    private final ChangeItemBeanUtils changeItemBeanUtils;
    private final IssueEventHelper issueEventUtil;

    @Autowired
    public ServiceDeskIssueEventEmailNotifier(UserFactory userFactory, IssueConversationalNotificationManager conversationalNotificationManager, PortalInternalManager portalInternalManager, ServiceDeskInternalManager serviceDeskInternalManager, IssueEventTypeHelper issueEventTypeHelper, CommentService commentService, InternalSDCommentManager internalSDCommentManager, RequestParticipantsInternalManager requestParticipantsInternalManager, ParticipantsCustomFieldManager participantsCustomFieldManager, StatusAndResolutionActivityProvider statusAndResolutionActivityProvider, SafeRunner safeRunner, CustomerContextService customerContextService, ChangeItemBeanUtils changeItemBeanUtils, IssueEventHelper issueEventUtil) {
        this.userFactory = userFactory;
        this.conversationalNotificationManager = conversationalNotificationManager;
        this.portalInternalManager = portalInternalManager;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.issueEventTypeHelper = issueEventTypeHelper;
        this.commentService = commentService;
        this.internalSDCommentManager = internalSDCommentManager;
        this.requestParticipantsInternalManager = requestParticipantsInternalManager;
        this.participantsCustomFieldManager = participantsCustomFieldManager;
        this.statusAndResolutionActivityProvider = statusAndResolutionActivityProvider;
        this.safeRunner = safeRunner;
        this.customerContextService = customerContextService;
        this.changeItemBeanUtils = changeItemBeanUtils;
        this.issueEventUtil = issueEventUtil;
    }

    public void onIssueEvent(IssueEvent issueEvent) {
        this.safeRunner.run(() -> this.customerContextService.runInCustomerContext(() -> this.triggerRelevantEvent(issueEvent)));
    }

    public void onIssueChangedEvent(IssueChangedEvent issueChangedEvent) {
        this.safeRunner.run(() -> this.customerContextService.runInCustomerContext(() -> this.triggerRelevantEvent(issueChangedEvent)));
    }

    public void onCommentCreatedEvent(CommentCreatedEvent commentCreatedEvent) {
        this.safeRunner.run(() -> this.customerContextService.runInCustomerContext(() -> this.triggerRelevantEvent(commentCreatedEvent)));
    }

    public void onCommentUpdatedEvent(CommentUpdatedEvent commentCreatedEvent) {
        this.safeRunner.run(() -> this.customerContextService.runInCustomerContext(() -> this.triggerRelevantEvent(commentCreatedEvent)));
    }

    private void triggerRelevantEvent(IssueChangedEvent issueChangedEvent) {
        Issue issue = issueChangedEvent.getIssue();
        Collection changeItems = issueChangedEvent.getChangeItems();
        Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option(issueChangedEvent.getAuthor().orElse(null))).then(this::wrapAsCheckedUser).then((eventInitiator, sdEventInitiator) -> io.atlassian.fugue.Option.option((Object)issue.getProjectObject())).then((eventInitiator, sdEventInitiator, project) -> this.portalInternalManager.getPortalByProject((Project)project).toOption()).then((eventInitiator, sdEventInitiator, project, portal) -> this.serviceDeskInternalManager.getServiceDesk((Project)project, false).toOption()).yield((eventInitiator, sdEventInitiator, project, portal, serviceDesk) -> {
            io.atlassian.fugue.Option<Comment> commentOpt = this.retrievePublicCommentOpt((ApplicationUser)eventInitiator, (io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option(issueChangedEvent.getComment().orElse(null)));
            if (this.participantsCustomFieldManager.participantsHasChanged(changeItems)) {
                this.onParticipantChanged((CheckedUser)sdEventInitiator, false, issue, changeItems, (Portal)portal, (ServiceDesk)serviceDesk);
            }
            if (this.isFieldSet(issueChangedEvent.getIssue(), issueChangedEvent.getChangeItems(), "resolution")) {
                this.onIssueResolved((CheckedUser)sdEventInitiator, issue, (Portal)portal, (ServiceDesk)serviceDesk, commentOpt);
            } else if (this.hasCustomerVisibleStatusChanged((CheckedUser)sdEventInitiator, issue, changeItems, (Portal)portal)) {
                this.onIssueStatusChanged((CheckedUser)sdEventInitiator, changeItems, issue, (Portal)portal, (ServiceDesk)serviceDesk, commentOpt);
            } else {
                commentOpt.foreach(comment -> this.onIssueCommented((CheckedUser)sdEventInitiator, issue, (Comment)comment, (Portal)portal, (ServiceDesk)serviceDesk));
            }
            return Unit.Unit();
        });
    }

    private void triggerRelevantEvent(CommentCreatedEvent commentCreatedEvent) {
        Comment comment = commentCreatedEvent.getComment();
        Issue issue = comment.getIssue();
        Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)comment.getAuthorApplicationUser())).then(this::wrapAsCheckedUser).then((eventInitiator, sdEventInitiator) -> io.atlassian.fugue.Option.option((Object)issue.getProjectObject())).then((eventInitiator, sdEventInitiator, project) -> this.portalInternalManager.getPortalByProject((Project)project).toOption()).then((eventInitiator, sdEventInitiator, project, portal) -> this.serviceDeskInternalManager.getServiceDesk((Project)project, false).toOption()).yield((eventInitiator, sdEventInitiator, project, portal, serviceDesk) -> {
            io.atlassian.fugue.Option<Comment> commentOpt = this.retrievePublicCommentOpt((ApplicationUser)eventInitiator, (io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option((Object)comment));
            commentOpt.foreach(publicComment -> this.onIssueCommented((CheckedUser)sdEventInitiator, issue, (Comment)publicComment, (Portal)portal, (ServiceDesk)serviceDesk));
            return Unit.Unit();
        });
    }

    private void triggerRelevantEvent(CommentUpdatedEvent commentUpdatedEvent) {
        Comment comment = commentUpdatedEvent.getComment();
        Issue issue = comment.getIssue();
        Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)comment.getAuthorApplicationUser())).then(this::wrapAsCheckedUser).then((eventInitiator, sdEventInitiator) -> io.atlassian.fugue.Option.option((Object)issue.getProjectObject())).then((eventInitiator, sdEventInitiator, project) -> this.portalInternalManager.getPortalByProject((Project)project).toOption()).then((eventInitiator, sdEventInitiator, project, portal) -> this.serviceDeskInternalManager.getServiceDesk((Project)project, false).toOption()).yield((eventInitiator, sdEventInitiator, project, portal, serviceDesk) -> {
            io.atlassian.fugue.Option<Comment> commentOpt = this.retrievePublicCommentOpt((ApplicationUser)eventInitiator, (io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option((Object)comment));
            commentOpt.foreach(publicComment -> this.onIssueCommented((CheckedUser)sdEventInitiator, issue, (Comment)publicComment, (Portal)portal, (ServiceDesk)serviceDesk));
            return Unit.Unit();
        });
    }

    private void triggerRelevantEvent(IssueEvent issueEvent) {
        Issue issue = issueEvent.getIssue();
        boolean isCreatedEvent = this.issueEventUtil.isCreatedEvent(issueEvent);
        if (isCreatedEvent) {
            Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)issueEvent.getUser())).then(this::wrapAsCheckedUser).then((eventInitiator, sdEventInitiator) -> io.atlassian.fugue.Option.option((Object)issue.getProjectObject())).then((eventInitiator, sdEventInitiator, project) -> this.portalInternalManager.getPortalByProject((Project)project).toOption()).then((eventInitiator, sdEventInitiator, project, portal) -> this.serviceDeskInternalManager.getServiceDesk((Project)project, false).toOption()).yield((eventInitiator, sdEventInitiator, project, portal, serviceDesk) -> {
                List changeItems = this.issueEventUtil.getChangeItemBeans(issueEvent);
                if (this.participantsHasChanged(issueEvent, changeItems)) {
                    this.onParticipantChanged((CheckedUser)sdEventInitiator, isCreatedEvent, issue, changeItems, (Portal)portal, (ServiceDesk)serviceDesk);
                }
                this.onIssueCreated((CheckedUser)sdEventInitiator, issue, (Portal)portal, (ServiceDesk)serviceDesk);
                return Unit.Unit();
            });
        }
    }

    private io.atlassian.fugue.Option<CheckedUser> wrapAsCheckedUser(ApplicationUser user) {
        return StepsConverters.newerOption((Option)this.userFactory.wrap(user).toOption());
    }

    private void onIssueCreated(CheckedUser executor, Issue issue, Portal portal, ServiceDesk serviceDesk) {
        this.conversationalNotificationManager.sendEmailForIssueCreated(executor, issue, portal, serviceDesk);
    }

    private void onIssueCommented(CheckedUser executor, Issue issue, Comment comment, Portal portal, ServiceDesk serviceDesk) {
        this.conversationalNotificationManager.sendEmailForIssueCommented(executor, issue, comment, portal, serviceDesk);
    }

    private void onIssueStatusChanged(CheckedUser executor, Collection<ChangeItemBean> changeItems, Issue issue, Portal portal, ServiceDesk serviceDesk, io.atlassian.fugue.Option<Comment> commentOpt) {
        if (this.isFieldClear(issue, changeItems, "resolution")) {
            this.conversationalNotificationManager.sendEmailForIssueReOpened(executor, issue, portal, serviceDesk, commentOpt);
        } else {
            commentOpt.foreach(comment -> this.onIssueCommented(executor, issue, (Comment)comment, portal, serviceDesk));
        }
    }

    private void onIssueResolved(CheckedUser executor, Issue issue, Portal portal, ServiceDesk serviceDesk, io.atlassian.fugue.Option<Comment> commentOpt) {
        this.conversationalNotificationManager.sendEmailForIssueResolved(executor, issue, portal, serviceDesk, commentOpt);
    }

    private void onParticipantChanged(CheckedUser executor, boolean isCreated, Issue issue, Collection<ChangeItemBean> changeItemBeans, Portal portal, ServiceDesk serviceDesk) {
        this.conversationalNotificationManager.sendEmailForParticipantChange(executor, isCreated, issue, changeItemBeans, portal, serviceDesk);
    }

    private boolean participantsHasChanged(IssueEvent issueEvent, Collection<ChangeItemBean> changeItems) {
        return this.participantsCustomFieldManager.participantsHasChanged(changeItems) || this.participantsFieldSetOnCreate(issueEvent);
    }

    private boolean participantsFieldSetOnCreate(IssueEvent issueEvent) {
        return this.issueEventTypeHelper.isEventOfType(issueEvent, EventType.ISSUE_CREATED_ID) && this.participantsExist(issueEvent);
    }

    private boolean participantsExist(IssueEvent issueEvent) {
        return io.atlassian.fugue.Option.option((Object)issueEvent.getIssue()).flatMap(issue -> this.requestParticipantsInternalManager.getValidParticipants((Issue)issue).toOption()).exists(participants -> !participants.isEmpty());
    }

    private boolean isFieldSet(Issue issue, Collection<ChangeItemBean> beans, String field) {
        return beans.stream().filter(bean -> field.equalsIgnoreCase(bean.getField())).anyMatch(bean -> FieldChangeType.SET.equals((Object)this.changeItemBeanUtils.extractFieldChangeType(bean, issue)));
    }

    private boolean isFieldClear(Issue issue, Collection<ChangeItemBean> changeItemBeans, String field) {
        Optional<ChangeItemBean> changeItemBean = changeItemBeans.stream().filter(changeItem -> changeItem.getField().equals(field) && FieldChangeType.CLEAR.equals((Object)this.changeItemBeanUtils.extractFieldChangeType(changeItem, issue))).findFirst();
        return changeItemBean.isPresent();
    }

    private boolean hasCustomerVisibleStatusChanged(CheckedUser user, Issue issue, Collection<ChangeItemBean> changeItems, Portal portal) {
        return this.statusAndResolutionActivityProvider.hasVisibleStatusChangedForCustomer(user, issue, changeItems, portal);
    }

    private io.atlassian.fugue.Option<Comment> retrievePublicCommentOpt(ApplicationUser user, io.atlassian.fugue.Option<Comment> commentOption) {
        return Steps.begin(commentOption).then(comment -> io.atlassian.fugue.Option.option((Object)comment.getAuthorApplicationUser())).then((comment, author) -> io.atlassian.fugue.Option.option((Object)this.commentService.getCommentById(user, comment.getId(), (ErrorCollection)new SimpleErrorCollection()))).then((comment, author, commentWithBrowseCheck) -> this.retrievePublicComment((Comment)comment)).yield((comment, author, commentWithBrowseChecked, publicComment) -> comment);
    }

    private io.atlassian.fugue.Option<Comment> retrievePublicComment(Comment comment) {
        if (!this.internalSDCommentManager.isCommentInternal(comment)) {
            return io.atlassian.fugue.Option.some((Object)comment);
        }
        return io.atlassian.fugue.Option.none();
    }
}

