/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.web.UrlProvider;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueUrlProvider
extends UrlProvider {
    private final ApplicationProperties applicationProperties;

    @Autowired
    public IssueUrlProvider(WebResourceUrlProvider webResourceUrlProvider, ApplicationProperties applicationProperties) {
        super(webResourceUrlProvider);
        this.applicationProperties = applicationProperties;
    }

    public URI getIssueURI(Issue issue, ProjectUrlsProvider.UrlMode urlMode) {
        Preconditions.checkNotNull((Object)urlMode);
        UriBuilder base = UriBuilder.fromUri((URI)this.baseUrl(urlMode));
        return base.path("browse").path(issue.getKey()).build(new Object[0]);
    }

    public String getIssueUrl(Issue issue) {
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        return String.format("%s/browse/%s", baseUrl, issue.getKey());
    }
}

