/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.images;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.images.TemporaryLogoManager;
import io.atlassian.fugue.Either;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TemporaryLogoService {
    private final ServiceDeskLicenseAndPermissionService permissionChecker;
    private final CommonErrors commonErrors;
    private final TemporaryLogoManager temporaryLogoManager;

    @Autowired
    public TemporaryLogoService(ServiceDeskLicenseAndPermissionService permissionChecker, CommonErrors commonErrors, TemporaryLogoManager temporaryLogoManager) {
        this.permissionChecker = permissionChecker;
        this.commonErrors = commonErrors;
        this.temporaryLogoManager = temporaryLogoManager;
    }

    public Either<AnError, Integer> storeForProject(CheckedUser user, Project projectLogoIsFor, InputStream logoInputStream) {
        if (!this.permissionChecker.canAdministerServiceDesk((SDUser)user, projectLogoIsFor)) {
            return this.cannotAdminProjectError();
        }
        return this.doStore(logoInputStream);
    }

    private Either<AnError, Integer> cannotAdminProjectError() {
        return Either.left((Object)this.commonErrors.PROJECT_ADMIN_PERMISSION());
    }

    private Either<AnError, Integer> doStore(InputStream logoInputStream) {
        return this.temporaryLogoManager.store(logoInputStream);
    }

    public Either<AnError, Integer> store(CheckedUser user, InputStream logoInputStream) {
        if (!this.permissionChecker.canAdministerJIRA((SDUser)user)) {
            return this.cannotAdministerJiraError();
        }
        return this.doStore(logoInputStream);
    }

    private Either<AnError, Integer> cannotAdministerJiraError() {
        return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }
}

