/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.images;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.images.ImageFileQStore;
import com.atlassian.servicedesk.internal.images.LogoReader;
import io.atlassian.fugue.Either;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemporaryLogoManager {
    private static final Logger log = LoggerFactory.getLogger(TemporaryLogoManager.class);
    private final LogoReader logoReader;
    private final ImageFileQStore imageFileStore;

    @Autowired
    TemporaryLogoManager(LogoReader logoReader, ImageFileQStore imageFileStore) {
        this.logoReader = logoReader;
        this.imageFileStore = imageFileStore;
    }

    public Either<AnError, Integer> store(InputStream logoInputStream) {
        return Steps.begin(this.logoReader.readBase64EncodedLogo(logoInputStream)).then(logoBytes -> this.imageFileStore.storeBase64Image(this.removeTypePrefixIfPresent((String)logoBytes)).toRight(this::logoNotStoredError)).yield((logoBytes, storedLogoId) -> storedLogoId);
    }

    private AnError logoNotStoredError() {
        ErrorMessage errorMessage = ErrorMessage.builder().message("Error when saving temporary logo to the database").build();
        return new AnError(errorMessage, 500);
    }

    private String removeTypePrefixIfPresent(String logoAsString) {
        return logoAsString.contains(",") ? StringUtils.substringAfter((String)logoAsString, (String)",") : logoAsString;
    }
}

