/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.images;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class LogoReader {
    private static final Logger log = LoggerFactory.getLogger(LogoReader.class);
    @VisibleForTesting
    static final int MAX_LOGO_FILE_SIZE_IN_BYTES = 0xA00000;

    LogoReader() {
    }

    Either<AnError, String> readBase64EncodedLogo(InputStream logoStream) {
        SizeLimitedInputStream limitedSizeStream = new SizeLimitedInputStream(logoStream, 0xA00000L);
        try {
            String base64EncodedImage = this.removeNoiseCharacters(IOUtils.toString((InputStream)((Object)limitedSizeStream)));
            return this.isValidImage(base64EncodedImage) ? Either.right((Object)base64EncodedImage) : this.unsupportedImageTypeError();
        }
        catch (LogoTooBigException tooBigException) {
            return this.logoTooBigError();
        }
        catch (IOException e) {
            return this.internalServerErrorWithMessage(String.format("Unable to save temporary logo due to: %s", e.getMessage()));
        }
    }

    private String removeNoiseCharacters(String uncleanString) {
        String prefixRemoved = uncleanString.contains(",") ? StringUtils.substringAfter((String)uncleanString, (String)",") : uncleanString;
        return prefixRemoved.replace("\n", "").replace("\r", "");
    }

    private boolean isValidImage(String base64EncodedImage) {
        try {
            return ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(base64EncodedImage))) != null;
        }
        catch (IllegalArgumentException e) {
            log.debug("Unable to read temporary logo, it's not properly base 64 encoded", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            log.debug("Unable to read temporary logo", (Throwable)e);
            return false;
        }
    }

    private Either<AnError, String> logoTooBigError() {
        return Either.left((Object)this.errorWithStatusCodeAndMessage(413, "Image was too big, max size allowed is %d bytes", 0xA00000));
    }

    private Either<AnError, String> unsupportedImageTypeError() {
        return Either.left((Object)this.errorWithStatusCodeAndMessage(415, "Image format not supported", new Object[0]));
    }

    private AnError errorWithStatusCodeAndMessage(int statusCode, String message, Object ... messageArgs) {
        ErrorMessage tokenisedMessage = ErrorMessage.builder().message(String.format(message, messageArgs)).build();
        return new AnError(tokenisedMessage, statusCode);
    }

    private Either<AnError, String> internalServerErrorWithMessage(String message) {
        return Either.left((Object)this.errorWithStatusCodeAndMessage(500, message, new Object[0]));
    }

    private static final class LogoTooBigException
    extends IOException {
        private LogoTooBigException() {
        }
    }

    private static final class SizeLimitedInputStream
    extends LimitedInputStream {
        public SizeLimitedInputStream(InputStream inputStream, long maxSizeInBytes) {
            super(inputStream, maxSizeInBytes);
        }

        protected void raiseError(long maxSizeInBytes, long currentCount) throws IOException {
            throw new LogoTooBigException();
        }
    }
}

