/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.images;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.LogoHandler;
import com.atlassian.servicedesk.internal.images.ImageFile;
import com.atlassian.servicedesk.internal.images.ImageFileImpl;
import com.atlassian.servicedesk.internal.images.ImageFileQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImageFileQStoreImpl
implements ImageFileQStore {
    private static final Logger log = LoggerFactory.getLogger(ImageFileQStoreImpl.class);
    private DatabaseAccessor databaseAccessor;

    private static ConstructorExpression<ImageFile> MAPPER() {
        return Projections.constructor(ImageFileImpl.class, (Expression[])new Expression[]{Tables.IMAGE.ID, Tables.IMAGE.CONTENTS});
    }

    @Autowired
    public ImageFileQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public Option<InputStream> getImageById(int id) {
        ImageFile imageFile = (ImageFile)this.databaseAccessor.runInTransaction(conn -> (ImageFile)((SQLQuery)((SQLQuery)conn.select(ImageFileQStoreImpl.MAPPER()).from((Expression)Tables.IMAGE)).where((Predicate)Tables.IMAGE.ID.eq((Object)id))).fetchOne());
        return Option.option((Object)imageFile).map(file -> LogoHandler.decode(file.getContent()));
    }

    @Override
    public Option<Integer> storeImageFile(File file) {
        return LogoHandler.encode(file).flatMap(content -> this.storeBase64Image((String)content).map(id -> this.logFileName(file, (int)id)));
    }

    private int logFileName(File file, int id) {
        log.debug("Storing image {} as {}", (Object)file.getName(), (Object)id);
        return id;
    }

    @Override
    public Option<Integer> storeBase64Image(String base64Image) {
        Integer id = (Integer)this.databaseAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.IMAGE).set((Path)Tables.IMAGE.CONTENTS, (Object)base64Image).executeWithKey(Tables.IMAGE.ID));
        return Option.option((Object)id);
    }

    @Override
    public void deleteImage(int id) {
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.IMAGE).where((Predicate)Tables.IMAGE.ID.eq((Object)id)).execute());
    }
}

