/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.fields.renderer;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.bootstrap.lifecycle.CustomerTextRendererAccessor;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerTextInternalRenderer;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.FieldValue;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.HtmlValue;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FieldRenderingHelper {
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;

    @Autowired
    public FieldRenderingHelper(FieldLayoutManager fieldLayoutManager, RendererManager rendererManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
    }

    public FieldValue getRenderedFieldValue(CheckedUser user, Issue issue, String fieldId, String value) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(fieldId);
        CustomerTextInternalRenderer customerTextRenderer = this.getCustomerTextRenderer();
        JiraRendererPlugin fieldRenderer = this.rendererManager.getRendererForField(fieldLayoutItem);
        String renderedValue = fieldRenderer.render(value, issue.getIssueRenderContext());
        String renderedText = customerTextRenderer.updateTextForCustomer(renderedValue, Option.some((Object)user), Option.some((Object)issue.getId()));
        return new HtmlValue(renderedText, value);
    }

    private CustomerTextInternalRenderer getCustomerTextRenderer() {
        return CustomerTextRendererAccessor.getCustomerTextRenderer();
    }
}

