/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.shareparticipants;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.organization.CustomerOrganizationParticipantService;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.CustomerInviteManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.FailedInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.SuccessInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidation;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.invite.RequestParticipantsInvitationService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import com.atlassian.servicedesk.internal.feature.shareparticipants.RequestSharedWithOrganizationAnalyticsEvent;
import com.atlassian.servicedesk.internal.feature.shareparticipants.ShareParticipantErrorMessageHelper;
import com.atlassian.servicedesk.internal.feature.shareparticipants.ShareParticipantsResult;
import com.atlassian.servicedesk.internal.feature.shareparticipants.ShareParticipantsService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.share.request.ShareParticipantsRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShareParticipantsServiceImpl
implements ShareParticipantsService {
    private static final Logger log = LoggerFactory.getLogger(ShareParticipantsServiceImpl.class);
    private final RequestParticipantsInternalService requestParticipantsInternalService;
    private final CustomerOrganizationParticipantService organizationParticipantService;
    private final UserFactory userFactory;
    private final CustomerOrganizationManager organizationManager;
    private final RequestParticipantsInvitationService participantsInvitationService;
    private final IssueHelper issueHelper;
    private final ServiceDeskManager serviceDeskManager;
    private final RequestParticipantValidator participantValidator;
    private final FeatureManager featureManager;
    private final ShareParticipantErrorMessageHelper errorMessageHelper;
    private final RequestParticipantError participantError;
    private final AnalyticsService analyticsService;
    private final CustomerServiceValidator customerServiceValidator;
    private final CustomerInviteManager customerInviteManager;

    @Autowired
    public ShareParticipantsServiceImpl(RequestParticipantsInternalService requestParticipantsInternalService, CustomerOrganizationParticipantService organizationParticipantService, UserFactory userFactory, CustomerOrganizationManager organizationManager, RequestParticipantsInvitationService participantsInvitationService, IssueHelper issueHelper, ServiceDeskManager serviceDeskManager, RequestParticipantValidator participantValidator, FeatureManager featureManager, ShareParticipantErrorMessageHelper errorMessageHelper, RequestParticipantError participantError, AnalyticsService analyticsService, CustomerServiceValidator customerServiceValidator, CustomerInviteManager customerInviteManager) {
        this.requestParticipantsInternalService = requestParticipantsInternalService;
        this.organizationParticipantService = organizationParticipantService;
        this.userFactory = userFactory;
        this.organizationManager = organizationManager;
        this.participantsInvitationService = participantsInvitationService;
        this.issueHelper = issueHelper;
        this.serviceDeskManager = serviceDeskManager;
        this.participantValidator = participantValidator;
        this.featureManager = featureManager;
        this.errorMessageHelper = errorMessageHelper;
        this.participantError = participantError;
        this.analyticsService = analyticsService;
        this.customerServiceValidator = customerServiceValidator;
        this.customerInviteManager = customerInviteManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ShareParticipantsResult> shareParticipants(@Nonnull CheckedUser user, @Nonnull Issue issue, @Nonnull ShareParticipantsRequest shareParticipantsRequest) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(issue, "issue");
        Objects.requireNonNull(shareParticipantsRequest, "shareParticipantsRequest");
        return Steps.begin(this.getValidUsersFromUserNamesAndEmails(user, issue, shareParticipantsRequest.getUsernames(), shareParticipantsRequest.getEmails())).then(participantUsers -> io.atlassian.fugue.Either.right(this.organizationManager.getOrganizationsById(shareParticipantsRequest.getOrganisationIds()))).then((participants, organizations) -> this.addParticipantsToIssue(user, issue, (List<CheckedUser>)participants)).then((participants, organizations, addedUsers) -> this.addOrganizationsToIssue(user, issue, (Collection<CustomerOrganization>)organizations)).yield((participants, organizations, addedUsers, addedOrganizations) -> this.getShareParticipantsResult(issue, (List<CheckedUser>)addedUsers, (Collection<CustomerOrganization>)addedOrganizations));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, JSDSuccess> removeOrganizationFromIssue(CheckedUser user, Issue issue, int organizationId) {
        return Steps.begin(this.organizationManager.getOrganizationById(organizationId)).then(organization -> this.organizationParticipantService.removeOrganizationsFromIssue(user, issue, (Collection)Lists.newArrayList((Object[])new CustomerOrganization[]{organization}))).yield((organization, result) -> JSDSuccess.success());
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, List<CheckedUser>> getValidUsersFromUserNamesAndEmails(CheckedUser user, Issue issue, List<String> usernames, List<String> emails) {
        return Steps.begin(this.issueHelper.getProjectFromIssue(issue)).then(arg_0 -> ((ServiceDeskManager)this.serviceDeskManager).getServiceDeskForProject(arg_0)).then((project, servicedesk) -> this.getAndInviteValidUsersFromUsernames(user, usernames, (Project)project, (ServiceDesk)servicedesk)).then((project, servicedesk, participantFromUserNames) -> this.getAndInviteValidUsersFromEmails(user, emails, issue, (Project)project, (ServiceDesk)servicedesk)).yield((project, servicedesk, participantFromUserNames, participantFromEmails) -> {
            ArrayList validUsers = new ArrayList();
            validUsers.addAll(participantFromUserNames);
            validUsers.addAll(participantFromEmails);
            return validUsers;
        });
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, List<CheckedUser>> getAndInviteValidUsersFromUsernames(CheckedUser executingUser, List<String> usernames, Project project, ServiceDesk serviceDesk) {
        return StepsConverters.newerEither((Either)this.userFactory.wrapUsernames(usernames)).flatMap(checkedUsers -> {
            if (!this.featureManager.isEnabled(SDFeatureFlags.OUTSIDER_COMMENTS)) {
                return io.atlassian.fugue.Either.right((Object)checkedUsers);
            }
            Pair customerPartitionPair = io.atlassian.fugue.Iterables.partition((Iterable)checkedUsers, user -> this.customerServiceValidator.isCustomerForProject((CheckedUser)user, project));
            ImmutableList existingCustomers = ImmutableList.copyOf((Iterable)((Iterable)customerPartitionPair.left()));
            ImmutableList notExistingCustomers = ImmutableList.copyOf((Iterable)((Iterable)customerPartitionPair.right()));
            if (notExistingCustomers.isEmpty()) {
                return io.atlassian.fugue.Either.right((Object)existingCustomers);
            }
            if (this.customerServiceValidator.isUserAllowedInviteOutsiderCustomer(executingUser, project, serviceDesk)) {
                return this.inviteExistingUsers(executingUser, (Collection<CheckedUser>)notExistingCustomers, project, serviceDesk).map(arg_0 -> ShareParticipantsServiceImpl.lambda$null$10((List)existingCustomers, arg_0));
            }
            List<String> usernamesNotExistingCustomer = notExistingCustomers.stream().map(CheckedUser::getName).collect(Collectors.toList());
            return io.atlassian.fugue.Either.left((Object)this.participantError.INVALID_PARTICIPANT_USERNAMES_ERROR(usernamesNotExistingCustomer));
        });
    }

    private io.atlassian.fugue.Either<AnError, List<CheckedUser>> getAndInviteValidUsersFromEmails(CheckedUser user, List<String> emails, Issue issue, Project project, ServiceDesk serviceDesk) {
        if (emails.isEmpty()) {
            return io.atlassian.fugue.Either.right(Collections.emptyList());
        }
        Collection<CheckedUser> existingEmailUsers = this.participantValidator.getParticipantsByEmails(emails, issue);
        Set existingCustomerEmails = existingEmailUsers.stream().map(CheckedUser::getEmailAddress).collect(Collectors.toSet());
        HashSet<String> nonCustomerEmails = new HashSet<String>(emails);
        nonCustomerEmails.removeAll(existingCustomerEmails);
        if (nonCustomerEmails.size() > RequestParticipantsInvitationService.MAX_NUMBER_OF_NEW_USERS_IN_ONE_REQUEST) {
            return io.atlassian.fugue.Either.left((Object)this.participantError.RATE_LIMIT_REQUEST_PARTICIPANT_FAIL(RequestParticipantsInvitationService.MAX_NUMBER_OF_NEW_USERS_IN_ONE_REQUEST));
        }
        io.atlassian.fugue.Either<AnError, List<CheckedUser>> inviteProcessResult = this.inviteNewParticipants(user, nonCustomerEmails, issue, project, serviceDesk);
        inviteProcessResult.left().forEach(error -> log.debug(error.getMessage().getMessage()));
        List invitedUsers = (List)inviteProcessResult.getOrElse(Collections.emptyList());
        Set<String> emailNotInvited = this.extractNotInvitedEmail(nonCustomerEmails, invitedUsers);
        if (!emailNotInvited.isEmpty()) {
            log.trace(String.format("There are %d users in add participants request, out of %d, found for %s : %s", emailNotInvited.size(), nonCustomerEmails.size(), issue.getKey(), emailNotInvited.toString()));
            return io.atlassian.fugue.Either.left((Object)this.errorMessageHelper.createShareParticipantError(user, issue, emailNotInvited));
        }
        ArrayList<CheckedUser> validUsers = new ArrayList<CheckedUser>();
        validUsers.addAll(invitedUsers);
        validUsers.addAll(existingEmailUsers);
        return io.atlassian.fugue.Either.right(validUsers);
    }

    private io.atlassian.fugue.Either<AnError, RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result> filterReporterAndCurrentParticipants(Set<String> emails, Option<CheckedUser> reporter, Set<CheckedUser> currentRequestParticipants) {
        RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result filterPhase1Result = this.participantsInvitationService.filterParticipantEmailsPhase1(new HashSet<String>(emails), reporter, currentRequestParticipants);
        if (!filterPhase1Result.isValid()) {
            return io.atlassian.fugue.Either.left((Object)ErrorBuilder.errorBuilder().addError("There are no possible participants left to add from request").buildSingleError());
        }
        return io.atlassian.fugue.Either.right((Object)filterPhase1Result);
    }

    private io.atlassian.fugue.Either<AnError, RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result> filterPotentialSignUpEmail(CheckedUser user, RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result phase1Result, Project project, ServiceDesk serviceDesk) {
        RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result filterPhase2Result = this.participantsInvitationService.filterParticipantEmailsPhase2(user, serviceDesk, project, phase1Result);
        if (!filterPhase2Result.isValid()) {
            return io.atlassian.fugue.Either.left((Object)ErrorBuilder.errorBuilder().addError("There are no possible participants left that could be invited from request").buildSingleError());
        }
        return io.atlassian.fugue.Either.right((Object)filterPhase2Result);
    }

    private io.atlassian.fugue.Either<AnError, List<CheckedUser>> inviteNewParticipants(CheckedUser user, Collection<String> emails, Issue issue, Project project, ServiceDesk serviceDesk) {
        io.atlassian.fugue.Either inviteResult = Steps.begin(this.filterReporterAndCurrentParticipants(new HashSet<String>(emails), (Option<CheckedUser>)Option.none(), new HashSet<CheckedUser>())).then(phase1Result -> this.filterPotentialSignUpEmail(user, (RequestParticipantsInvitationService.ParticipantsInviteFilterPhase1Result)phase1Result, project, serviceDesk)).then((phase1Result, potentialSignupEmails) -> this.participantsInvitationService.rateLimitParticipantsInviteCheck((RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result)potentialSignupEmails)).then((phase1Result, potentialSignupEmails, success) -> this.participantsInvitationService.inviteNewParticipants(user, issue, (RequestParticipantsInvitationService.ParticipantsInviteFilterPhase2Result)potentialSignupEmails)).yield((phase1Result, potentialSignupEmails, success, invitationResult) -> invitationResult);
        if (inviteResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)inviteResult.left().get());
        }
        RequestParticipantsInvitationService.ParticipantsInviteInvitationResult participantsInviteResult = (RequestParticipantsInvitationService.ParticipantsInviteInvitationResult)inviteResult.right().get();
        if (!participantsInviteResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)ErrorBuilder.errorBuilder().addError("There were no invitations attempted ....").buildSingleError());
        }
        return io.atlassian.fugue.Either.right((Object)ImmutableList.copyOf(this.participantValidator.getParticipantsByEmails(participantsInviteResult.getAllResultEmails(), project)));
    }

    private io.atlassian.fugue.Either<AnError, List<CheckedUser>> inviteExistingUsers(CheckedUser user, Collection<CheckedUser> existingUsers, Project project, ServiceDesk serviceDesk) {
        Set<String> usernames = existingUsers.stream().map(CheckedUser::getName).collect(Collectors.toSet());
        return Steps.begin(this.customerInviteManager.validateInviteCustomersByEmailOrUsername(user, serviceDesk, project, usernames)).then(this::processCustomerInviteValidationResult).then((customerInviteValidationResult, unit) -> this.customerInviteManager.inviteCustomers((CustomerInviteManager.CustomerInviteValidationResult)customerInviteValidationResult)).then((customerInviteValidationResult, unit, inviteCustomerResult) -> this.processInviteCustomerResultForUsernames((InviteCustomerResult)inviteCustomerResult, project)).yield((customerInviteValidationResult, unit, inviteCustomerResult, checkedUsers) -> checkedUsers);
    }

    private io.atlassian.fugue.Either<AnError, Unit> processCustomerInviteValidationResult(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult) {
        List invalidValidations = customerInviteValidationResult.getCustomerInviteValidations().stream().filter(customerInviteValidation -> !customerInviteValidation.getCustomerInviteValidationStatus().isValid()).collect(Collectors.toList());
        if (invalidValidations.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Either.left((Object)this.participantError.INVALID_PARTICIPANT_USERNAMES_ERROR(Lists.transform(invalidValidations, CustomerInviteValidation::extractUsernameOrEmailAddress)));
    }

    private io.atlassian.fugue.Either<AnError, List<CheckedUser>> processInviteCustomerResultForUsernames(InviteCustomerResult inviteCustomerResult, Project project) {
        if (inviteCustomerResult.hasFailedInvite()) {
            return io.atlassian.fugue.Either.left((Object)this.participantError.INVALID_PARTICIPANT_USERNAMES_ERROR(Lists.transform(inviteCustomerResult.getFailedInvites(), FailedInviteResult::getEmailAddressOrUsername)));
        }
        io.atlassian.fugue.Either convertedUserKeysToCheckedUsers = Eithers.sequenceRight((Iterable)inviteCustomerResult.getSuccessInvites().stream().map(SuccessInviteResult::getKey).map(arg_0 -> ((UserFactory)this.userFactory).wrapUserKey(arg_0)).map(StepsConverters::newerEither).collect(Collectors.toList()));
        return convertedUserKeysToCheckedUsers.map(checkedUsers -> Iterables.transform((Iterable)checkedUsers, CheckedUser::getName)).map(ImmutableList::copyOf).map(usernames -> this.participantValidator.getParticipantsByUsernames((Collection<String>)usernames, project)).map(ImmutableList::copyOf);
    }

    private Set<String> extractNotInvitedEmail(Collection<String> emails, Collection<CheckedUser> invitedUsers) {
        Set invitedUsernames = invitedUsers.stream().map(CheckedUser::getName).collect(Collectors.toSet());
        HashSet<String> emailNotInvited = new HashSet<String>(emails);
        emailNotInvited.removeAll(invitedUsernames);
        List invitedUserEmail = invitedUsers.stream().map(CheckedUser::getEmailAddress).collect(Collectors.toList());
        emailNotInvited.removeAll(invitedUserEmail);
        return emailNotInvited;
    }

    private io.atlassian.fugue.Either<AnError, List<CheckedUser>> addParticipantsToIssue(CheckedUser user, Issue issue, List<CheckedUser> participants) {
        if (participants.isEmpty()) {
            return io.atlassian.fugue.Either.right(Collections.emptyList());
        }
        return this.requestParticipantsInternalService.addParticipants(user, issue, participants);
    }

    private io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> addOrganizationsToIssue(CheckedUser user, Issue issue, Collection<CustomerOrganization> organizations) {
        if (organizations.isEmpty()) {
            return io.atlassian.fugue.Either.right(Collections.emptyList());
        }
        return this.organizationParticipantService.addOrganizationsToIssue(user, issue, organizations);
    }

    private ShareParticipantsResult getShareParticipantsResult(Issue issue, List<CheckedUser> addedUsers, Collection<CustomerOrganization> addedOrganizations) {
        if (!addedOrganizations.isEmpty()) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new RequestSharedWithOrganizationAnalyticsEvent(issue.getProjectId()));
        }
        return new ShareParticipantsResult(addedUsers, Lists.newArrayList(addedOrganizations));
    }

    private static /* synthetic */ List lambda$null$10(List existingCustomers, List invited) {
        return ImmutableList.copyOf((Iterable)io.atlassian.fugue.Iterables.concat((Iterable[])new Iterable[]{existingCustomers, invited}));
    }
}

