/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.shareparticipants;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShareParticipantErrorMessageHelper {
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerUrlUtil customerUrlUtil;

    @Autowired
    public ShareParticipantErrorMessageHelper(RequestParticipantPermissionService requestParticipantPermissionService, ServiceDeskPermissions serviceDeskPermissions, CustomerUrlUtil customerUrlUtil) {
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerUrlUtil = customerUrlUtil;
    }

    public AnError createShareParticipantError(@Nonnull CheckedUser user, @Nonnull Issue issue, @Nonnull Set<String> invalidEmails) {
        String errorString;
        boolean isAgent2 = this.serviceDeskPermissions.canViewAgentView((SDUser)user, issue);
        boolean isJIRAAdmin = this.serviceDeskPermissions.canAdministerJIRA((SDUser)user);
        I18nHelper i18nHelper = user.i18NHelper();
        if (isJIRAAdmin || isAgent2) {
            Element errorEmailList = new Element(Tag.valueOf((String)"ul"), "");
            invalidEmails.forEach(email -> errorEmailList.appendElement("li").text(email));
            Element errorBody = new Element(Tag.valueOf((String)"div"), "");
            errorBody.appendElement("br");
            errorBody.appendChild((Node)errorEmailList);
            errorBody.appendElement("br");
            String errorFooter = "";
            errorFooter = isJIRAAdmin ? i18nHelper.getText("sd.customer.portal.participants.invite.error.footer", this.createLinkStartTag(this.getUserManagementHomeUrl(false, this.customerUrlUtil.getJIRABaseUrl(false))), "</a>") : i18nHelper.getText("sd.customer.portal.participants.invite.error.footer.agent");
            String errorTitle = i18nHelper.getText("sd.customer.portal.participants.invite.error.title");
            errorString = errorTitle + "\n" + (errorBody.html() + "\n") + errorFooter;
        } else {
            errorString = i18nHelper.getText("sd.request.participants.username.error", StringUtils.join(invalidEmails, (String)", "));
        }
        return new AnError(ErrorMessage.builder().message(errorString).build(), HttpStatusCode.BAD_REQUEST);
    }

    private String createLinkStartTag(String url) {
        return "<a href=\"" + url + "\">";
    }

    private String getUserManagementHomeUrl(boolean isOnDemand, String jiraBaseUrl) {
        if (isOnDemand) {
            return StringUtils.stripEnd((String)jiraBaseUrl, (String)"/") + "/admin/users";
        }
        return StringUtils.stripEnd((String)jiraBaseUrl, (String)"/") + "/secure/admin/user/UserBrowser.jspa";
    }
}

